/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AbstractInterpreterFacade<CRITERION, INTERPRETER> {
    protected final Map<CRITERION, INTERPRETER> interpretersMap;

    public AbstractInterpreterFacade(List<INTERPRETER> interpreters, Function<INTERPRETER, Set<CRITERION>> criteriaExtractor) {
        this.interpretersMap = interpreters.stream().flatMap(interpreter -> ((Set)criteriaExtractor.apply(interpreter)).stream().map(criterion -> ImmutablePair.of((Object)criterion, (Object)interpreter))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected INTERPRETER interpreter(CRITERION criterion) {
        return Optional.ofNullable(this.interpretersMap.get(criterion)).orElseThrow(() -> new UnsupportedOperationException(String.format("No interpreter registered for %s in %s", criterion, this.getClass().getName())));
    }
}

