/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.context;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.DistributedByType;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.DecisionFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.ProcessGroupByType;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

public class DateAggregationContext {
    private AggregateByDateUnit aggregateByDateUnit;
    private final String dateField;
    private final String runningDateReportEndDateField;
    private final MinMaxStatDto minMaxStats;
    private boolean extendBoundsToMinMaxStats = false;
    private final ZoneId timezone;
    private final String dateAggregationName;
    private final List<DecisionFilterDto<?>> decisionFilters;
    private final ProcessGroupByType processGroupByType;
    private final DistributedByType distributedByType;
    private final List<ProcessFilterDto<?>> processFilters;
    private final FilterContext filterContext;

    protected DateAggregationContext(DateAggregationContextBuilder<?, ?> b) {
        this.aggregateByDateUnit = b.aggregateByDateUnit;
        if (this.aggregateByDateUnit == null) {
            throw new IllegalArgumentException("aggregateByDateUnit cannot be null");
        }
        this.dateField = b.dateField;
        if (this.dateField == null) {
            throw new IllegalArgumentException("dateField cannot be null");
        }
        this.runningDateReportEndDateField = b.runningDateReportEndDateField;
        this.minMaxStats = b.minMaxStats;
        if (this.minMaxStats == null) {
            throw new IllegalArgumentException("minMaxStats cannot be null");
        }
        this.extendBoundsToMinMaxStats = b.extendBoundsToMinMaxStatsSet ? b.extendBoundsToMinMaxStatsValue : DateAggregationContext.defaultExtendBoundsToMinMaxStats();
        this.timezone = b.timezone;
        if (this.timezone == null) {
            throw new IllegalArgumentException("timezone cannot be null");
        }
        this.dateAggregationName = b.dateAggregationName;
        this.decisionFilters = b.decisionFilters;
        this.processGroupByType = b.processGroupByType;
        this.distributedByType = b.distributedByType;
        this.processFilters = b.processFilters;
        this.filterContext = b.filterContext;
        if (this.filterContext == null) {
            throw new IllegalArgumentException("filterContext cannot be null");
        }
    }

    public ZonedDateTime getEarliestDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Math.round(this.minMaxStats.getMin())), this.timezone);
    }

    public ZonedDateTime getLatestDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Math.round(this.minMaxStats.getMax())), this.timezone);
    }

    public Optional<String> getDateAggregationName() {
        return Optional.ofNullable(this.dateAggregationName);
    }

    public boolean isStartDateAggregation() {
        if (this.processGroupByType != null) {
            return ProcessGroupByType.START_DATE.equals((Object)this.processGroupByType);
        }
        return DistributedByType.START_DATE.equals((Object)this.distributedByType);
    }

    public AggregateByDateUnit getAggregateByDateUnit() {
        return this.aggregateByDateUnit;
    }

    public void setAggregateByDateUnit(AggregateByDateUnit aggregateByDateUnit) {
        if (aggregateByDateUnit == null) {
            throw new IllegalArgumentException("aggregateByDateUnit cannot be null");
        }
        this.aggregateByDateUnit = aggregateByDateUnit;
    }

    public String getDateField() {
        return this.dateField;
    }

    public String getRunningDateReportEndDateField() {
        return this.runningDateReportEndDateField;
    }

    public MinMaxStatDto getMinMaxStats() {
        return this.minMaxStats;
    }

    public boolean isExtendBoundsToMinMaxStats() {
        return this.extendBoundsToMinMaxStats;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public List<DecisionFilterDto<?>> getDecisionFilters() {
        return this.decisionFilters;
    }

    public ProcessGroupByType getProcessGroupByType() {
        return this.processGroupByType;
    }

    public DistributedByType getDistributedByType() {
        return this.distributedByType;
    }

    public List<ProcessFilterDto<?>> getProcessFilters() {
        return this.processFilters;
    }

    public FilterContext getFilterContext() {
        return this.filterContext;
    }

    private static boolean defaultExtendBoundsToMinMaxStats() {
        return false;
    }

    public static DateAggregationContextBuilder<?, ?> builder() {
        return new DateAggregationContextBuilderImpl();
    }

    public static abstract class DateAggregationContextBuilder<C extends DateAggregationContext, B extends DateAggregationContextBuilder<C, B>> {
        private AggregateByDateUnit aggregateByDateUnit;
        private String dateField;
        private String runningDateReportEndDateField;
        private MinMaxStatDto minMaxStats;
        private boolean extendBoundsToMinMaxStatsValue;
        private boolean extendBoundsToMinMaxStatsSet;
        private ZoneId timezone;
        private String dateAggregationName;
        private List<DecisionFilterDto<?>> decisionFilters;
        private ProcessGroupByType processGroupByType;
        private DistributedByType distributedByType;
        private List<ProcessFilterDto<?>> processFilters;
        private FilterContext filterContext;

        public B aggregateByDateUnit(AggregateByDateUnit aggregateByDateUnit) {
            this.aggregateByDateUnit = aggregateByDateUnit;
            if (aggregateByDateUnit == null) {
                throw new IllegalArgumentException("aggregateByDateUnit cannot be null");
            }
            return this.self();
        }

        public B dateField(String dateField) {
            this.dateField = dateField;
            if (dateField == null) {
                throw new IllegalArgumentException("dateField cannot be null");
            }
            return this.self();
        }

        public B runningDateReportEndDateField(String runningDateReportEndDateField) {
            this.runningDateReportEndDateField = runningDateReportEndDateField;
            return this.self();
        }

        public B minMaxStats(MinMaxStatDto minMaxStats) {
            this.minMaxStats = minMaxStats;
            if (minMaxStats == null) {
                throw new IllegalArgumentException("minMaxStats cannot be null");
            }
            return this.self();
        }

        public B extendBoundsToMinMaxStats(boolean extendBoundsToMinMaxStats) {
            this.extendBoundsToMinMaxStatsValue = extendBoundsToMinMaxStats;
            this.extendBoundsToMinMaxStatsSet = true;
            return this.self();
        }

        public B timezone(ZoneId timezone) {
            this.timezone = timezone;
            if (timezone == null) {
                throw new IllegalArgumentException("timezone cannot be null");
            }
            return this.self();
        }

        public B dateAggregationName(String dateAggregationName) {
            this.dateAggregationName = dateAggregationName;
            return this.self();
        }

        public B decisionFilters(List<DecisionFilterDto<?>> decisionFilters) {
            this.decisionFilters = decisionFilters;
            return this.self();
        }

        public B processGroupByType(ProcessGroupByType processGroupByType) {
            this.processGroupByType = processGroupByType;
            return this.self();
        }

        public B distributedByType(DistributedByType distributedByType) {
            this.distributedByType = distributedByType;
            return this.self();
        }

        public B processFilters(List<ProcessFilterDto<?>> processFilters) {
            this.processFilters = processFilters;
            return this.self();
        }

        public B filterContext(FilterContext filterContext) {
            this.filterContext = filterContext;
            if (filterContext == null) {
                throw new IllegalArgumentException("filterContext cannot be null");
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "DateAggregationContext.DateAggregationContextBuilder(aggregateByDateUnit=" + String.valueOf(this.aggregateByDateUnit) + ", dateField=" + this.dateField + ", runningDateReportEndDateField=" + this.runningDateReportEndDateField + ", minMaxStats=" + String.valueOf(this.minMaxStats) + ", extendBoundsToMinMaxStatsValue=" + this.extendBoundsToMinMaxStatsValue + ", timezone=" + String.valueOf(this.timezone) + ", dateAggregationName=" + this.dateAggregationName + ", decisionFilters=" + String.valueOf(this.decisionFilters) + ", processGroupByType=" + String.valueOf(this.processGroupByType) + ", distributedByType=" + String.valueOf(this.distributedByType) + ", processFilters=" + String.valueOf(this.processFilters) + ", filterContext=" + String.valueOf(this.filterContext) + ")";
        }
    }

    private static final class DateAggregationContextBuilderImpl
    extends DateAggregationContextBuilder<DateAggregationContext, DateAggregationContextBuilderImpl> {
        private DateAggregationContextBuilderImpl() {
        }

        @Override
        protected DateAggregationContextBuilderImpl self() {
            return this;
        }

        @Override
        public DateAggregationContext build() {
            return new DateAggregationContext(this);
        }
    }
}

