/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.CombinedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.ReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.SingleReportConfigurationDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.report.CombinedReportEvaluator;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import io.camunda.optimize.service.db.report.SingleReportEvaluator;
import io.camunda.optimize.service.exceptions.OptimizeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.evaluation.ReportEvaluationException;
import io.camunda.optimize.service.exceptions.evaluation.TooManyBucketsException;
import io.camunda.optimize.service.identity.CollapsedSubprocessNodesService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.ValidationHelper;
import io.camunda.optimize.service.variable.ProcessVariableService;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class ReportEvaluationHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReportService reportService;
    private final SingleReportEvaluator singleReportEvaluator;
    private final CombinedReportEvaluator combinedReportEvaluator;
    private final ProcessVariableService processVariableService;
    private final DefinitionService definitionService;
    private final CollapsedSubprocessNodesService collapsedSubprocessNodesService;

    public ReportEvaluationHandler(ReportService reportService, SingleReportEvaluator singleReportEvaluator, CombinedReportEvaluator combinedReportEvaluator, ProcessVariableService processVariableService, DefinitionService definitionService, CollapsedSubprocessNodesService collapsedSubprocessNodesService) {
        this.reportService = reportService;
        this.singleReportEvaluator = singleReportEvaluator;
        this.combinedReportEvaluator = combinedReportEvaluator;
        this.processVariableService = processVariableService;
        this.definitionService = definitionService;
        this.collapsedSubprocessNodesService = collapsedSubprocessNodesService;
    }

    public AuthorizedReportEvaluationResult evaluateReport(ReportEvaluationInfo evaluationInfo) {
        evaluationInfo.postFetchSavedReport(this.reportService);
        this.updateAndSetLatestReportDefinitionXml(evaluationInfo);
        this.setDataSourcesForSystemGeneratedReports(evaluationInfo);
        RoleType currentUserRole = this.getAuthorizedRole(evaluationInfo.getUserId(), evaluationInfo.getReport()).orElseThrow(() -> new ForbiddenException(String.format("User [%s] is not authorized to evaluate report [%s].", evaluationInfo.getUserId(), evaluationInfo.getReport().getName())));
        CombinedReportEvaluationResult result = evaluationInfo.getReport().isCombined() ? this.evaluateCombinedReport(evaluationInfo, currentUserRole) : this.evaluateSingleReportWithErrorCheck(evaluationInfo, currentUserRole);
        return new AuthorizedReportEvaluationResult((ReportEvaluationResult)result, currentUserRole);
    }

    private void updateAndSetLatestReportDefinitionXml(ReportEvaluationInfo reportEvaluationInfo) {
        this.reportService.updateReportDefinitionXmlIfRequiredAndReturn(reportEvaluationInfo.getReport()).ifPresent(reportEvaluationInfo::updateReportDefinitionXml);
    }

    private void setDataSourcesForSystemGeneratedReports(ReportEvaluationInfo reportEvaluationInfo) {
        ReportDataDto reportDataDto = reportEvaluationInfo.getReport().getData();
        if (reportDataDto instanceof ProcessReportDataDto) {
            ProcessReportDataDto processReportData = (ProcessReportDataDto)reportDataDto;
            if (processReportData.isManagementReport()) {
                List definitionsForManagementReport = this.definitionService.getFullyImportedDefinitions(DefinitionType.PROCESS, reportEvaluationInfo.getUserId()).stream().map(def -> new ReportDataDefinitionDto(def.getKey(), def.getName(), List.of("all"), def.getTenants().stream().map(TenantDto::getId).collect(Collectors.toList()), def.getName())).collect(Collectors.toList());
                processReportData.setDefinitions(definitionsForManagementReport);
            } else if (processReportData.isInstantPreviewReport() && !reportEvaluationInfo.isSharedReport()) {
                String key = ((SingleReportDataDto)reportEvaluationInfo.getReport().getData()).getDefinitionKey();
                List definitionForInstantPreviewReport = this.definitionService.getDefinitionWithAvailableTenants(DefinitionType.PROCESS, key, reportEvaluationInfo.getUserId()).stream().map(def -> new ReportDataDefinitionDto(def.getKey(), def.getName(), List.of("all"), def.getTenants().stream().map(TenantDto::getId).collect(Collectors.toList()), def.getName())).collect(Collectors.toList());
                processReportData.setDefinitions(definitionForInstantPreviewReport);
            }
        }
    }

    private CombinedReportEvaluationResult evaluateCombinedReport(ReportEvaluationInfo evaluationInfo, RoleType currentUserRole) {
        CombinedReportDefinitionRequestDto combinedReportDefinitionDto = (CombinedReportDefinitionRequestDto)evaluationInfo.getReport();
        ValidationHelper.validateCombinedReportDefinition(combinedReportDefinitionDto, currentUserRole);
        evaluationInfo.getPagination().ifPresent(pagination -> {
            if (pagination.getLimit() != null || pagination.getOffset() != null) {
                throw new OptimizeValidationException("Pagination cannot be applied to combined reports");
            }
        });
        List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions = this.getAuthorizedSingleReportDefinitions(evaluationInfo);
        AtomicReference singleReportResultType = new AtomicReference();
        List<SingleReportEvaluationResult<?>> resultList = this.combinedReportEvaluator.evaluate(singleReportDefinitions, evaluationInfo.getTimezone()).stream().filter(this::isProcessMapOrNumberResult).filter(singleReportResult -> singleReportResult.getFirstCommandResult().getClass().equals(singleReportResultType.get()) || singleReportResultType.compareAndSet(null, singleReportResult.getFirstCommandResult().getClass())).collect(Collectors.toList());
        long instanceCount = this.combinedReportEvaluator.evaluateCombinedReportInstanceCount(singleReportDefinitions);
        return new CombinedReportEvaluationResult(resultList, instanceCount, combinedReportDefinitionDto);
    }

    private boolean isProcessMapOrNumberResult(SingleReportEvaluationResult<?> reportResult) {
        ResultType resultType = reportResult.getFirstCommandResult().getType();
        return ResultType.MAP.equals((Object)resultType) || ResultType.NUMBER.equals((Object)resultType);
    }

    private List<SingleProcessReportDefinitionRequestDto> getAuthorizedSingleReportDefinitions(ReportEvaluationInfo evaluationInfo) {
        CombinedReportDefinitionRequestDto combinedReportDefinitionDto = (CombinedReportDefinitionRequestDto)evaluationInfo.getReport();
        String userId = evaluationInfo.getUserId();
        List singleReportIds = ((CombinedReportDataDto)combinedReportDefinitionDto.getData()).getReportIds();
        List<SingleProcessReportDefinitionRequestDto> foundSingleReports = this.reportService.getAllSingleProcessReportsForIdsOmitXml(singleReportIds).stream().filter(reportDefinition -> this.getAuthorizedRole(userId, (ReportDefinitionDto<?>)reportDefinition).isPresent()).peek(reportDefinition -> this.addAdditionalFiltersForReport(evaluationInfo, (ReportDefinitionDto<?>)reportDefinition)).collect(Collectors.toList());
        if (foundSingleReports.size() != singleReportIds.size()) {
            throw new OptimizeValidationException("Some of the single reports contained in the combined report with id [" + combinedReportDefinitionDto.getId() + "] could not be found");
        }
        return foundSingleReports;
    }

    protected abstract Optional<RoleType> getAuthorizedRole(String var1, ReportDefinitionDto<?> var2);

    private ReportEvaluationResult evaluateSingleReportWithErrorCheck(ReportEvaluationInfo evaluationInfo, RoleType currentUserRole) {
        this.addAdditionalFiltersForReport(evaluationInfo, evaluationInfo.getReport());
        this.addHiddenFlowNodeIds(evaluationInfo);
        try {
            ReportEvaluationContext context = ReportEvaluationContext.fromReportEvaluation(evaluationInfo);
            return this.singleReportEvaluator.evaluate(context);
        }
        catch (OptimizeException | OptimizeValidationException e) {
            AuthorizedReportDefinitionResponseDto authorizedReportDefinitionDto = new AuthorizedReportDefinitionResponseDto(evaluationInfo.getReport(), currentUserRole);
            throw new ReportEvaluationException(authorizedReportDefinitionDto, (Exception)e);
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isTooManyBucketsException((RuntimeException)e)) {
                AuthorizedReportDefinitionResponseDto authorizedReportDefinitionDto = new AuthorizedReportDefinitionResponseDto(evaluationInfo.getReport(), currentUserRole);
                throw new TooManyBucketsException(authorizedReportDefinitionDto, e);
            }
            throw e;
        }
    }

    private void addAdditionalFiltersForReport(ReportEvaluationInfo evaluationInfo, ReportDefinitionDto<?> reportDefinition) {
        if (evaluationInfo.isSharedReport()) {
            this.addAdditionalFiltersForReport(reportDefinition, evaluationInfo.getAdditionalFilters());
        } else {
            this.addAdditionalFiltersForAuthorizedReport(evaluationInfo.getUserId(), reportDefinition, evaluationInfo.getAdditionalFilters());
        }
    }

    private void addHiddenFlowNodeIds(ReportEvaluationInfo evaluationInfo) {
        ProcessReportDataDto processReportDataDto;
        ReportDataDto reportDataDto = evaluationInfo.getReport().getData();
        if (reportDataDto instanceof ProcessReportDataDto && (processReportDataDto = (ProcessReportDataDto)reportDataDto).getVisualization() == ProcessVisualization.HEAT && Optional.ofNullable(processReportDataDto.getConfiguration()).map(SingleReportConfigurationDto::getXml).isPresent()) {
            evaluationInfo.setHiddenFlowNodeIds(this.collapsedSubprocessNodesService.getCollapsedSubprocessNodeIdsForReport(processReportDataDto));
        }
    }

    private void addAdditionalFiltersForAuthorizedReport(String userId, ReportDefinitionDto<?> reportDefinitionDto, AdditionalProcessReportEvaluationFilterDto additionalFilters) {
        this.addAdditionalFiltersForReport(reportDefinitionDto, additionalFilters, () -> this.processVariableService.getVariableNamesForAuthorizedReports(userId, Collections.singletonList(reportDefinitionDto.getId())));
    }

    private void addAdditionalFiltersForReport(ReportDefinitionDto<?> reportDefinitionDto, AdditionalProcessReportEvaluationFilterDto additionalFilters) {
        this.addAdditionalFiltersForReport(reportDefinitionDto, additionalFilters, () -> this.processVariableService.getVariableNamesForReports(Collections.singletonList(reportDefinitionDto.getId())));
    }

    private void addAdditionalFiltersForReport(ReportDefinitionDto<?> reportDefinitionDto, AdditionalProcessReportEvaluationFilterDto additionalFilters, Supplier<List<ProcessVariableNameResponseDto>> varNameSupplier) {
        if (additionalFilters != null && !CollectionUtils.isEmpty((Collection)additionalFilters.getFilter())) {
            if (reportDefinitionDto instanceof SingleProcessReportDefinitionRequestDto) {
                SingleProcessReportDefinitionRequestDto definitionDto = (SingleProcessReportDefinitionRequestDto)reportDefinitionDto;
                EnumMap variableFiltersByTypeForReport = additionalFilters.getFilter().stream().anyMatch(filter -> filter.getData() instanceof VariableFilterDataDto) ? varNameSupplier.get().stream().collect(Collectors.groupingBy(ProcessVariableNameResponseDto::getType, () -> new EnumMap(VariableType.class), Collectors.mapping(ProcessVariableNameResponseDto::getName, Collectors.toSet()))) : new EnumMap(VariableType.class);
                List additionalFiltersToApply = additionalFilters.getFilter().stream().filter(additionalFilter -> {
                    FilterDataDto patt0$temp = additionalFilter.getData();
                    if (patt0$temp instanceof VariableFilterDataDto) {
                        VariableFilterDataDto filterData = (VariableFilterDataDto)patt0$temp;
                        Set variableNamesForType = variableFiltersByTypeForReport.getOrDefault(filterData.getType(), Collections.emptySet());
                        return variableNamesForType.contains(filterData.getName());
                    }
                    return true;
                }).collect(Collectors.toList());
                List existingFilter = ((ProcessReportDataDto)definitionDto.getData()).getFilter();
                if (existingFilter != null) {
                    existingFilter.addAll(additionalFiltersToApply);
                } else {
                    ((ProcessReportDataDto)definitionDto.getData()).setFilter(additionalFiltersToApply);
                }
            } else {
                this.logger.debug("Cannot add additional filters to report [{}] as it is not a process report", (Object)reportDefinitionDto.getId());
            }
        }
    }
}

