/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

public class MinMaxStatDto {
    private double min;
    private double max;
    private String minAsString;
    private String maxAsString;

    public MinMaxStatDto(double min, double max) {
        this.min = min;
        this.max = max;
        this.minAsString = Double.toString(min);
        this.maxAsString = Double.toString(max);
    }

    public MinMaxStatDto(double min, double max, String minAsString, String maxAsString) {
        this.min = min;
        this.max = max;
        this.minAsString = minAsString;
        this.maxAsString = maxAsString;
    }

    public double getRange() {
        return this.max - this.min;
    }

    public boolean isMinValid() {
        return Double.isFinite(this.min);
    }

    public boolean isMaxValid() {
        return Double.isFinite(this.max);
    }

    public boolean isValidRange() {
        return this.isMinValid() && this.isMaxValid() && this.min != this.max;
    }

    public boolean isEmpty() {
        return !this.isMinValid() && !this.isMaxValid();
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public String getMinAsString() {
        return this.minAsString;
    }

    public void setMinAsString(String minAsString) {
        this.minAsString = minAsString;
    }

    public String getMaxAsString() {
        return this.maxAsString;
    }

    public void setMaxAsString(String maxAsString) {
        this.maxAsString = maxAsString;
    }

    public String toString() {
        return "MinMaxStatDto(min=" + this.getMin() + ", max=" + this.getMax() + ", minAsString=" + this.getMinAsString() + ", maxAsString=" + this.getMaxAsString() + ")";
    }
}

