/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ExecutionPlanExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionPlanExtractor.class);
    final ApplicationContext applicationContext;
    final ConfigurationService configurationService;
    final Map<String, ExecutionPlan> executionPlans = new HashMap<String, ExecutionPlan>();
    private final ObjectMapper objectMapper;

    public ExecutionPlanExtractor(ApplicationContext applicationContext, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.applicationContext = applicationContext;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        boolean isAssigneeAnalyticsEnabled = configurationService.getUiConfiguration().isUserTaskAssigneeAnalyticsEnabled();
        this.executionPlans.putAll(Arrays.stream(ProcessExecutionPlan.values()).filter(plan -> isAssigneeAnalyticsEnabled || !plan.isAssigneeReport()).collect(Collectors.toMap(ExecutionPlan::getCommandKey, Function.identity())));
        this.executionPlans.putAll(Arrays.stream(DecisionExecutionPlan.values()).collect(Collectors.toMap(ExecutionPlan::getCommandKey, Function.identity())));
    }

    public <R extends ReportDefinitionDto<?>> List<ExecutionPlan> extractExecutionPlans(R reportDefinition) {
        return reportDefinition.getData().createCommandKeys().stream().map(commandKey -> this.resolve((String)commandKey, reportDefinition)).toList();
    }

    private <R extends ReportDefinitionDto<?>> ExecutionPlan resolve(String commandKey, R reportDefinition) {
        return Optional.ofNullable(this.executionPlans.get(commandKey)).orElseThrow(() -> this.unsupportedError(commandKey, reportDefinition));
    }

    private <R extends ReportDefinitionDto<?>> OptimizeValidationException unsupportedError(String commandKey, R reportDefinition) {
        try {
            LOG.warn(String.format("The following settings combination of the report data is not supported in Optimize (commandKey=%s):\n{}\nTherefore returning error result.", commandKey), (Object)this.objectMapper.writeValueAsString(reportDefinition));
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to serialize report definition!", (Throwable)e);
        }
        throw new OptimizeValidationException("This combination of the settings of the report builder is not supported!");
    }
}

