/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader.importindex;

import io.camunda.optimize.dto.optimize.datasource.IngestedDataSourceDto;
import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.service.db.reader.importindex.ImportIndexReader;
import io.camunda.optimize.service.db.repository.ImportRepository;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimestampBasedImportIndexReader
implements ImportIndexReader<TimestampBasedImportIndexDto, IngestedDataSourceDto> {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampBasedImportIndexReader.class);
    final ImportRepository importRepository;

    public TimestampBasedImportIndexReader(ImportRepository importRepository) {
        this.importRepository = importRepository;
    }

    @Override
    public Optional<TimestampBasedImportIndexDto> getImportIndex(String typeIndexComesFrom, IngestedDataSourceDto dataSourceDto) {
        return this.importRepository.getImportIndex("timestamp-based-import-index", "timestamp based", TimestampBasedImportIndexDto.class, typeIndexComesFrom, dataSourceDto);
    }

    public List<TimestampBasedImportIndexDto> getAllImportIndicesForTypes(List<String> indexTypes) {
        return this.importRepository.getAllTimestampBasedImportIndicesForTypes(indexTypes);
    }
}

