/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.PageResultDto;
import io.camunda.optimize.service.db.reader.DefinitionInstanceReader;
import io.camunda.optimize.service.db.repository.ProcessInstanceRepository;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessInstanceReader.class);
    private final ProcessInstanceRepository processInstanceRepository;
    private final DefinitionInstanceReader definitionInstanceReader;

    public ProcessInstanceReader(ProcessInstanceRepository processInstanceRepository, DefinitionInstanceReader definitionInstanceReader) {
        this.processInstanceRepository = processInstanceRepository;
        this.definitionInstanceReader = definitionInstanceReader;
    }

    public PageResultDto<String> getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit) {
        return this.processInstanceRepository.getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(processDefinitionKey, endDate, limit);
    }

    public PageResultDto<String> getNextPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit, PageResultDto<String> previousPage) {
        return this.getNextPageOfProcessInstanceIds(previousPage, () -> this.getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(processDefinitionKey, endDate, limit));
    }

    public PageResultDto<String> getFirstPageOfProcessInstanceIdsThatEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit) {
        return this.processInstanceRepository.getFirstPageOfProcessInstanceIdsThatEndedBefore(processDefinitionKey, endDate, limit);
    }

    public PageResultDto<String> getNextPageOfProcessInstanceIdsThatEndedBefore(String processDefinitionKey, OffsetDateTime endDate, Integer limit, PageResultDto<String> previousPage) {
        return this.getNextPageOfProcessInstanceIds(previousPage, () -> this.getFirstPageOfProcessInstanceIdsThatEndedBefore(processDefinitionKey, endDate, limit));
    }

    public Set<String> getExistingProcessDefinitionKeysFromInstances() {
        return this.definitionInstanceReader.getAllExistingDefinitionKeys(DefinitionType.PROCESS);
    }

    public Optional<String> getProcessDefinitionKeysForInstanceId(String instanceId) {
        return this.definitionInstanceReader.getAllExistingDefinitionKeys(DefinitionType.PROCESS, Collections.singleton(instanceId)).stream().findFirst();
    }

    public boolean processDefinitionHasStartedInstances(String processDefinitionKey) {
        return this.processInstanceRepository.processDefinitionHasStartedInstances(processDefinitionKey);
    }

    private PageResultDto<String> getNextPageOfProcessInstanceIds(PageResultDto<String> previousPage, Supplier<PageResultDto<String>> firstPageFetchFunction) {
        return this.processInstanceRepository.getNextPageOfProcessInstanceIds(previousPage, firstPageFetchFunction);
    }
}

