/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.service.db.repository.VariableRepository;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExternalVariableReader {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalVariableReader.class);
    VariableRepository variableRepository;

    public ExternalVariableReader(VariableRepository variableRepository) {
        this.variableRepository = variableRepository;
    }

    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAfter(Long ingestTimestamp, int limit) {
        LOG.debug("Fetching variables that where ingested after {}", (Object)Instant.ofEpochMilli(ingestTimestamp));
        return this.variableRepository.getVariableUpdatesIngestedAfter(ingestTimestamp, limit);
    }

    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAt(Long ingestTimestamp) {
        LOG.debug("Fetching variables that where ingested at {}", (Object)Instant.ofEpochMilli(ingestTimestamp));
        return this.variableRepository.getVariableUpdatesIngestedAt(ingestTimestamp);
    }
}

