/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.query.collection.BaseCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionEntity;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.db.reader.ReportReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface EntitiesReader {
    public static final String INDEX_FIELD = "_index";
    public static final String AGG_BY_INDEX_COUNT = "byIndexCount";
    public static final String[] ENTITY_LIST_EXCLUDES = new String[]{ReportReader.REPORT_DATA_XML_PROPERTY};

    public List<CollectionEntity> getAllPrivateEntities();

    public List<CollectionEntity> getAllPrivateEntitiesForOwnerId(String var1);

    public Map<String, Map<EntityType, Long>> countEntitiesForCollections(List<? extends BaseCollectionDefinitionDto<?>> var1);

    public List<CollectionEntity> getAllEntitiesForCollection(String var1);

    public Optional<EntityNameResponseDto> getEntityNames(EntityNameRequestDto var1, String var2);

    default public String getLocalizedReportName(LocalizationService localizationService, CollectionEntity reportEntity, String locale) {
        if (reportEntity instanceof SingleProcessReportDefinitionRequestDto) {
            SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionRequestDto = (SingleProcessReportDefinitionRequestDto)reportEntity;
            if (((ProcessReportDataDto)singleProcessReportDefinitionRequestDto.getData()).isInstantPreviewReport()) {
                return localizationService.getLocalizationForInstantPreviewReportCode(locale, reportEntity.getName());
            }
            if (((ProcessReportDataDto)singleProcessReportDefinitionRequestDto.getData()).isManagementReport()) {
                return localizationService.getLocalizationForManagementReportCode(locale, reportEntity.getName());
            }
        }
        return reportEntity.getName();
    }
}

