/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.Collections;
import java.util.Set;

public abstract class DefinitionInstanceReader {
    public Set<String> getAllExistingDefinitionKeys(DefinitionType type) {
        return this.getAllExistingDefinitionKeys(type, Collections.emptySet());
    }

    public abstract Set<String> getAllExistingDefinitionKeys(DefinitionType var1, Set<String> var2);

    protected String resolveInstanceIdFieldForType(DefinitionType type) {
        return switch (type) {
            case DefinitionType.PROCESS -> "processInstanceId";
            case DefinitionType.DECISION -> "decisionInstanceId";
            default -> throw new OptimizeRuntimeException("Unsupported definition type:" + String.valueOf(type));
        };
    }

    protected String resolveDefinitionKeyFieldForType(DefinitionType type) {
        return switch (type) {
            case DefinitionType.PROCESS -> "processDefinitionKey";
            case DefinitionType.DECISION -> "decisionDefinitionKey";
            default -> throw new OptimizeRuntimeException("Unsupported definition type:" + String.valueOf(type));
        };
    }

    protected String resolveIndexMultiAliasForType(DefinitionType type) {
        return switch (type) {
            case DefinitionType.PROCESS -> "process-instance";
            case DefinitionType.DECISION -> "decision-instance";
            default -> throw new OptimizeRuntimeException("Unsupported definition type:" + String.valueOf(type));
        };
    }
}

