/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableValueRequestDto;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.repository.VariableRepository;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DecisionVariableReader {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionVariableReader.class);
    private final DecisionDefinitionReader decisionDefinitionReader;
    private final VariableRepository variableRepository;

    public DecisionVariableReader(DecisionDefinitionReader decisionDefinitionReader, VariableRepository variableRepository) {
        this.decisionDefinitionReader = decisionDefinitionReader;
        this.variableRepository = variableRepository;
    }

    public List<DecisionVariableNameResponseDto> getInputVariableNames(String decisionDefinitionKey, List<String> decisionDefinitionVersions, List<String> tenantIds) {
        if (decisionDefinitionVersions == null || decisionDefinitionVersions.isEmpty()) {
            LOG.debug("Cannot fetch output variable values for decision definition with missing versions.");
            return Collections.emptyList();
        }
        List decisionDefinitions = this.decisionDefinitionReader.getDecisionDefinition(decisionDefinitionKey, decisionDefinitionVersions, tenantIds).orElseThrow(() -> new OptimizeRuntimeException("Could not extract input variables. Requested decision definition not found!")).getInputVariableNames();
        decisionDefinitions.forEach(definition -> {
            if (definition.getName() == null) {
                definition.setName(definition.getId());
            }
        });
        return decisionDefinitions;
    }

    public List<DecisionVariableNameResponseDto> getOutputVariableNames(String decisionDefinitionKey, List<String> decisionDefinitionVersions, List<String> tenantIds) {
        if (decisionDefinitionVersions == null || decisionDefinitionVersions.isEmpty()) {
            return Collections.emptyList();
        }
        List decisionDefinitions = this.decisionDefinitionReader.getDecisionDefinition(decisionDefinitionKey, decisionDefinitionVersions, tenantIds).orElseThrow(() -> new OptimizeRuntimeException("Could not extract output variables. Requested decision definition not found!")).getOutputVariableNames();
        decisionDefinitions.forEach(definition -> {
            if (definition.getName() == null) {
                definition.setName(definition.getId());
            }
        });
        return decisionDefinitions;
    }

    public List<String> getInputVariableValues(DecisionVariableValueRequestDto requestDto) {
        if (requestDto.getDecisionDefinitionVersions() == null || requestDto.getDecisionDefinitionVersions().isEmpty()) {
            LOG.debug("Cannot fetch input variable values for decision definition with missing versions.");
            return Collections.emptyList();
        }
        LOG.debug("Fetching input variable values for decision definition with key [{}] and versions [{}]", (Object)requestDto.getDecisionDefinitionKey(), (Object)requestDto.getDecisionDefinitionVersions());
        return this.getVariableValues(requestDto, "inputs");
    }

    public List<String> getOutputVariableValues(DecisionVariableValueRequestDto requestDto) {
        if (requestDto.getDecisionDefinitionVersions() == null || requestDto.getDecisionDefinitionVersions().isEmpty()) {
            LOG.debug("Cannot fetch output variable values for decision definition with missing versions.");
            return Collections.emptyList();
        }
        LOG.debug("Fetching output variable values for decision definition with key [{}] and versions [{}]", (Object)requestDto.getDecisionDefinitionKey(), (Object)requestDto.getDecisionDefinitionVersions());
        return this.getVariableValues(requestDto, "outputs");
    }

    private List<String> getVariableValues(DecisionVariableValueRequestDto requestDto, String variablesPath) {
        return this.variableRepository.getDecisionVariableValues(requestDto, variablesPath);
    }
}

