/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public interface AssigneeAndCandidateGroupsReader {
    public static final String NESTED_USER_TASKS_AGG = "userTasks";
    public static final String COMPOSITE_AGG = "composite";
    public static final String TERMS_AGG = "userTaskFieldTerms";

    default public void consumeAssigneesInBatches(String engineAlias, Consumer<List<String>> assigneeBatchConsumer, int batchSize) {
        if (engineAlias == null) {
            throw new IllegalArgumentException("engineAlias cannot be null");
        }
        if (assigneeBatchConsumer == null) {
            throw new IllegalArgumentException("assigneeBatchConsumer cannot be null");
        }
        this.consumeUserTaskFieldTermsInBatches("dataSource.name", engineAlias, "assignee", assigneeBatchConsumer, batchSize);
    }

    default public void consumeCandidateGroupsInBatches(String engineAlias, Consumer<List<String>> candidateGroupBatchConsumer, int batchSize) {
        if (engineAlias == null) {
            throw new IllegalArgumentException("engineAlias cannot be null");
        }
        if (candidateGroupBatchConsumer == null) {
            throw new IllegalArgumentException("candidateGroupBatchConsumer cannot be null");
        }
        this.consumeUserTaskFieldTermsInBatches("dataSource.name", engineAlias, "candidateGroups", candidateGroupBatchConsumer, batchSize);
    }

    default public Set<String> getAssigneeIdsForProcess(Map<String, Set<String>> definitionKeyToTenantsMap) {
        return this.getUserTaskFieldTerms("assignee", definitionKeyToTenantsMap);
    }

    default public Set<String> getCandidateGroupIdsForProcess(Map<String, Set<String>> definitionKeyToTenantsMap) {
        return this.getUserTaskFieldTerms("candidateGroups", definitionKeyToTenantsMap);
    }

    default public void consumeUserTaskFieldTermsInBatches(String termField, String termValue, String userTaskFieldName, Consumer<List<String>> termBatchConsumer, int batchSize) {
        this.consumeUserTaskFieldTermsInBatches("process-instance", termField, termValue, userTaskFieldName, termBatchConsumer, batchSize);
    }

    default public String getUserTaskFieldPath(String fieldName) {
        return "flowNodeInstances." + fieldName;
    }

    public void consumeUserTaskFieldTermsInBatches(String var1, String var2, String var3, String var4, Consumer<List<String>> var5, int var6);

    public Set<String> getUserTaskFieldTerms(String var1, Map<String, Set<String>> var2);
}

