/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenSearchWriterUtil {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchWriterUtil.class);

    private OpenSearchWriterUtil() {
    }

    public static Script createFieldUpdateScript(Set<String> fields, Object entityDto, ObjectMapper objectMapper) {
        Map<String, JsonData> params = OpenSearchWriterUtil.createFieldUpdateScriptParams(fields, entityDto, objectMapper);
        return OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(DatabaseWriterUtil.createUpdateFieldsScript(params.keySet()), params);
    }

    public static Script createDefaultScriptWithPrimitiveParams(String inlineUpdateScript, Map<String, JsonData> params) {
        return QueryDSL.scriptFromJsonData((String)inlineUpdateScript, params);
    }

    public static Script createDefaultScriptWithSpecificDtoParams(String inlineUpdateScript, Map<String, JsonData> params) {
        return QueryDSL.scriptFromJsonData((String)inlineUpdateScript, params);
    }

    public static Map<String, JsonData> createFieldUpdateScriptParams(Set<String> fields, Object entityDto, ObjectMapper objectMapper) {
        Map entityAsMap = (Map)objectMapper.convertValue(entityDto, (TypeReference)new TypeReference<Map<String, Object>>(){});
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        for (String fieldName : fields) {
            Object fieldValue = entityAsMap.get(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue instanceof TemporalAccessor) {
                TemporalAccessor temporalAccessor = (TemporalAccessor)fieldValue;
                fieldValue = DATE_TIME_FORMATTER.format(temporalAccessor);
            }
            params.put(fieldName, JsonData.of(fieldValue));
        }
        return params;
    }

    public static Script createDefaultScript(String inlineUpdateScript) {
        return OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(inlineUpdateScript, Collections.emptyMap());
    }
}

