/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import io.camunda.optimize.dto.optimize.query.dashboard.InstantDashboardDataDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.builders.OptimizeDeleteOperationBuilderOS;
import io.camunda.optimize.service.db.writer.InstantDashboardMetadataWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class InstantDashboardMetadataWriterOS
implements InstantDashboardMetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(InstantDashboardMetadataWriterOS.class);
    private final OptimizeOpenSearchClient osClient;

    public InstantDashboardMetadataWriterOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public void saveInstantDashboard(InstantDashboardDataDto dashboardDataDto) {
        LOG.debug("Writing new Instant preview dashboard to Opensearch");
        String id = dashboardDataDto.getInstantDashboardId();
        IndexRequest.Builder requestBuilder = new IndexRequest.Builder().index("instant-dashboard").id(id).document((Object)dashboardDataDto).refresh(Refresh.True);
        Result result = this.osClient.index(requestBuilder).result();
        if (!Set.of(Result.Created, Result.Updated).contains(result)) {
            String message = "Could not write Instant preview dashboard data to Opensearch. Maybe the connection to Opensearch got lost?";
            LOG.error("Could not write Instant preview dashboard data to Opensearch. Maybe the connection to Opensearch got lost?");
            throw new OptimizeRuntimeException("Could not write Instant preview dashboard data to Opensearch. Maybe the connection to Opensearch got lost?");
        }
        LOG.debug("Instant preview dashboard information with id [{}] has been created", (Object)id);
    }

    @Override
    public List<String> deleteOutdatedTemplateEntriesAndGetExistingDashboardIds(List<Long> hashesAllowed) throws IOException {
        ArrayList<String> dashboardIdsToBeDeleted = new ArrayList<String>();
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index("instant-dashboard", new String[0]).query(q -> q.bool(b -> b.mustNot(m -> m.terms(t -> t.field("templateHash").terms(tt -> tt.value(hashesAllowed.stream().map(FieldValue::of).toList()))))));
        SearchResponse searchResponse = this.osClient.search(requestBuilder, InstantDashboardDataDto.class, "Some errors occurred while deleting outdated instant dashboards.");
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        LOG.debug("Deleting [{}] instant dashboard documents by id with bulk request.", (Object)searchResponse.hits().hits().size());
        ArrayList bulkOperations = new ArrayList();
        searchResponse.hits().hits().forEach(hit -> {
            assert (hit.source() != null);
            dashboardIdsToBeDeleted.add(((InstantDashboardDataDto)hit.source()).getDashboardId());
            bulkOperations.add(BulkOperation.of(o -> o.delete(OptimizeDeleteOperationBuilderOS.of(d -> (ObjectBuilder)d.optimizeIndex(this.osClient, "instant-dashboard").id(hit.id())))));
        });
        if (!bulkOperations.isEmpty()) {
            bulkRequestBuilder.operations(bulkOperations);
            this.osClient.bulk(bulkRequestBuilder, "Some errors occurred while deleting outdated instant dashboards.");
        }
        return dashboardIdsToBeDeleted;
    }
}

