/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleUpdateRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryUpdateDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.schema.index.CollectionIndex;
import io.camunda.optimize.service.db.writer.CollectionWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeCollectionConflictException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class CollectionWriterOS
implements CollectionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionWriterOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final DateTimeFormatter formatter;

    public CollectionWriterOS(OptimizeOpenSearchClient osClient, DateTimeFormatter formatter) {
        this.osClient = osClient;
        this.formatter = formatter;
    }

    @Override
    public void updateCollection(CollectionDefinitionUpdateDto collection, String id) {
        LOG.debug("Updating collection with id [{}] in OpenSearch", (Object)id);
        UpdateRequest.Builder request = new UpdateRequest.Builder().index("collection").id(id).doc((Object)collection).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        String errorMessage = String.format("Was not able to update collection with id [%s] and name [%s].", id, collection.getName());
        UpdateResponse updateResponse = this.osClient.update(request, errorMessage);
        if (updateResponse.shards().failed().intValue() > 0) {
            LOG.error("Was not able to update collection with id [{}] and name [{}].", (Object)id, (Object)collection.getName());
            throw new OptimizeRuntimeException("Was not able to update collection!");
        }
    }

    @Override
    public void deleteCollection(String collectionId) {
        LOG.debug("Deleting collection with id [{}]", (Object)collectionId);
        DeleteRequest.Builder request = new DeleteRequest.Builder().index("collection").id(collectionId).refresh(Refresh.True);
        String errorMessage = String.format("Could not delete collection with id [%s]. ", collectionId);
        DeleteResponse deleteResponse = this.osClient.delete(request, errorMessage);
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete collection with id [%s]. Collection does not exist. Maybe it was already deleted by someone else?", collectionId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void addScopeEntriesToCollection(String userId, String collectionId, List<CollectionScopeEntryDto> scopeUpdates) {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("scopeEntriesToUpdate", JsonData.of(scopeUpdates));
        params.put("lastModifier", JsonData.of((Object)userId));
        params.put("lastModified", JsonData.of((Object)this.formatter.format(LocalDateUtil.getCurrentDateTime())));
        Script updateEntityScript = OpenSearchWriterUtil.createDefaultScriptWithSpecificDtoParams("Map newScopes = ctx._source.data.scope.stream()\n  .collect(Collectors.toMap(s -> s.id, Function.identity()));\nparams.scopeEntriesToUpdate\n  .forEach(newScope -> {\n     newScopes.computeIfPresent(newScope.id, (key, oldScope) -> {\n       newScope.tenants = Stream.concat(oldScope.tenants.stream(), newScope.tenants.stream())\n        .distinct()\n        .collect(Collectors.toList());\n       return newScope;\n     });\n     newScopes.putIfAbsent(newScope.id, newScope);\n  });\nctx._source.data.scope = newScopes.values();\nctx._source.lastModifier = params.lastModifier;\nctx._source.lastModified = params.lastModified;\n", params);
        UpdateResponse updateResponse = this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
        if (updateResponse.result().equals((Object)Result.NotFound)) {
            String message = String.format("Was not able to add scope entries to collection with id [%s]. Collection does not exist!", collectionId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteScopeEntryFromAllCollections(String scopeEntryId) {
        String updateItem = String.format("collection scope entry with ID [%s].", scopeEntryId);
        LOG.info("Removing {} from all collections.", (Object)updateItem);
        Script removeScopeEntryFromCollectionsScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("def scopes = ctx._source.data.scope;\nif(scopes != null) {\n   scopes.removeIf(scope -> scope.id.equals(params.scopeEntryIdToRemove));\n}\n", Collections.singletonMap("scopeEntryIdToRemove", JsonData.of((Object)scopeEntryId)));
        Query query = new NestedQuery.Builder().path(CollectionIndex.DATA).query(new NestedQuery.Builder().path(String.join((CharSequence)".", CollectionIndex.DATA, CollectionIndex.SCOPE)).query(QueryDSL.term((String)String.join((CharSequence)".", CollectionIndex.DATA, CollectionIndex.SCOPE, CollectionScopeEntryDto.Fields.id.name()), (String)scopeEntryId)).scoreMode(ChildScoreMode.None).build().toQuery()).scoreMode(ChildScoreMode.None).build().toQuery();
        this.osClient.updateByQuery("collection", query, removeScopeEntryFromCollectionsScript);
    }

    @Override
    public void updateScopeEntity(String collectionId, CollectionScopeEntryUpdateDto scopeEntry, String userId, String scopeEntryId) {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("entryDto", JsonData.of((Object)scopeEntry));
        params.put("entryId", JsonData.of((Object)scopeEntryId));
        params.put("lastModifier", JsonData.of((Object)userId));
        params.put("lastModified", JsonData.of((Object)this.formatter.format(LocalDateUtil.getCurrentDateTime())));
        Script updateEntityScript = OpenSearchWriterUtil.createDefaultScriptWithSpecificDtoParams("def optionalEntry = ctx._source.data.scope.stream()\n  .filter(s -> s.id.equals(params.entryId))\n  .findFirst();\nif (optionalEntry.isPresent()) {\n  def entry = optionalEntry.get();\n  entry.tenants = params.entryDto.tenants;\n  ctx._source.lastModifier = params.lastModifier;\n  ctx._source.lastModified = params.lastModified;\n} else {\n  throw new Exception('Cannot find scope entry.');\n}\n", params);
        this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
    }

    @Override
    public void removeScopeEntries(String collectionId, List<String> scopeEntryIds, String userId) throws NotFoundException {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("ids", JsonData.of(scopeEntryIds));
        params.put("lastModifier", JsonData.of((Object)userId));
        params.put("lastModified", JsonData.of((Object)this.formatter.format(LocalDateUtil.getCurrentDateTime())));
        Script updateEntityScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("for (id in params.ids) {\n  ctx._source.data.scope.removeIf(scope -> scope.id.equals(id));\n}\nctx._source.lastModifier = params.lastModifier;\nctx._source.lastModified = params.lastModified;\n", params);
        this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
    }

    @Override
    public void removeScopeEntry(String collectionId, String scopeEntryId, String userId) throws NotFoundException {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("id", JsonData.of((Object)scopeEntryId));
        params.put("lastModifier", JsonData.of((Object)userId));
        params.put("lastModified", JsonData.of((Object)this.formatter.format(LocalDateUtil.getCurrentDateTime())));
        Script updateEntityScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("boolean removed = ctx._source.data.scope.removeIf(scope -> scope.id.equals(params.id));\nif (removed) {\n  ctx._source.lastModifier = params.lastModifier;\n  ctx._source.lastModified = params.lastModified;\n} else {\n  ctx.op = \"none\";\n}\n", params);
        UpdateResponse updateResponse = this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
        if (updateResponse.result().equals((Object)Result.NoOp)) {
            String message = String.format("Scope entry for id [%s] doesn't exist.", scopeEntryId);
            LOG.warn(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void addRoleToCollection(String collectionId, List<CollectionRoleRequestDto> rolesToAdd, String userId) {
        LOG.debug("Adding roles {} to collection with id [{}] in OpenSearch.", rolesToAdd, (Object)collectionId);
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("rolesToAdd", JsonData.of(rolesToAdd));
        params.put("lastModifier", JsonData.of((Object)userId));
        params.put("lastModified", JsonData.of((Object)this.formatter.format(LocalDateUtil.getCurrentDateTime())));
        Script addEntityScript = OpenSearchWriterUtil.createDefaultScriptWithSpecificDtoParams("def newRoles = new ArrayList();\nfor (roleToAdd in params.rolesToAdd) {\n    boolean exists = ctx._source.data.roles.stream()\n       .anyMatch(existingRole -> existingRole.id.equals(roleToAdd.id));\n    if (!exists){\n      newRoles.add(roleToAdd);\n    }\n}\nif (newRoles.size() == params.rolesToAdd.size()) {\n    ctx._source.data.roles.addAll(newRoles);\n    ctx._source.lastModifier = params.lastModifier;\n    ctx._source.lastModified = params.lastModified;\n} else {\n    ctx.op = \"none\";\n}\n", params);
        UpdateResponse updateResponse = this.executeUpdateRequest(collectionId, addEntityScript, "Was not able to update collection with id [%s].");
        if (updateResponse.result().equals((Object)Result.NoOp)) {
            String message = String.format("One of the roles %s already exists in collection [%s].", rolesToAdd, collectionId);
            LOG.warn(message);
            throw new OptimizeCollectionConflictException(message);
        }
    }

    @Override
    public void updateRoleInCollection(String collectionId, String roleEntryId, CollectionRoleUpdateRequestDto roleUpdateDto, String userId) throws OptimizeConflictException {
        UpdateResponse updateResponse;
        LOG.debug("Updating the role [{}] in collection with id [{}] in OpenSearch.", (Object)roleEntryId, (Object)collectionId);
        Map<String, JsonData> params = this.constructParamsForRoleUpdateScript(roleEntryId, userId);
        params.put("role", JsonData.of((Object)roleUpdateDto.getRole().toString()));
        Script addEntityScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n   def existingEntry = optionalExistingEntry.get();\n   def moreThanOneManagerPresent = ctx._source.data.roles.stream()\n   .filter(dto -> params.managerRole.equals(dto.role))\n   .limit(2)\n   .count()\n    == 2;\nif (!moreThanOneManagerPresent && params.managerRole.equals(existingEntry.role)) {\n// updating of last manager is not allowed\n   ctx.op = \"none\";\n} else {\n   existingEntry.role = params.role;\n   ctx._source.lastModifier = params.lastModifier;\n   ctx._source.lastModified = params.lastModified;\n}\n} else {\nthrow new Exception('Cannot find role.');\n}\n", params);
        try {
            updateResponse = this.executeUpdateRequest(collectionId, addEntityScript, "Was not able to update collection with id [%s].");
        }
        catch (OpenSearchException e) {
            String errorMessage = String.format("Was not able to update role with id [%s] on collection with id [%s]. Collection or role does not exist!", roleEntryId, collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
        if (updateResponse.result().equals((Object)Result.NoOp)) {
            String message = String.format("Cannot assign lower privileged role to last [%s] of collection [%s].", RoleType.MANAGER, collectionId);
            LOG.warn(message);
            throw new OptimizeCollectionConflictException(message);
        }
    }

    @Override
    public void removeRoleFromCollectionUnlessIsLastManager(String collectionId, String roleEntryId, String userId) throws OptimizeConflictException {
        Map<String, JsonData> params = this.constructParamsForRoleUpdateScript(roleEntryId, userId);
        this.removeRoleFromCollectionUnlessIsLastManager(collectionId, roleEntryId, params);
    }

    @Override
    public void persistCollection(String id, CollectionDefinitionDto collectionDefinitionDto) {
        IndexRequest.Builder request = new IndexRequest.Builder().index("collection").id(id).document((Object)collectionDefinitionDto).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(request);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = "Could not write collection to Opensearch. ";
            LOG.error("Could not write collection to Opensearch. ");
            throw new OptimizeRuntimeException("Could not write collection to Opensearch. ");
        }
        LOG.debug("Collection with id [{}] has successfully been created.", (Object)id);
    }

    private UpdateResponse executeUpdateRequest(String collectionId, Script updateEntityScript, String errorMessage) {
        UpdateRequest.Builder request = new UpdateRequest.Builder().index("collection").id(collectionId).script(updateEntityScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        UpdateResponse updateResponse = this.osClient.update(request, errorMessage);
        if (updateResponse.shards().failed().intValue() > 0) {
            String message = String.format(errorMessage, collectionId);
            LOG.error(message, (Object)collectionId);
            throw new OptimizeRuntimeException(message);
        }
        return updateResponse;
    }

    private void removeRoleFromCollectionUnlessIsLastManager(String collectionId, String roleEntryId, Map<String, JsonData> params) throws OptimizeConflictException {
        UpdateResponse updateResponse;
        LOG.debug("Deleting the role [{}] in collection with id [{}] in OpenSearch.", (Object)roleEntryId, (Object)collectionId);
        Script addEntityScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n    def existingEntry = optionalExistingEntry.get();\n    def moreThanOneManagerPresent = ctx._source.data.roles.stream()\n    .filter(dto -> params.managerRole.equals(dto.role))\n    .limit(2)\n    .count()\n     == 2;\n    if (!moreThanOneManagerPresent && params.managerRole.equals(existingEntry.role)) {\n        // deletion of last manager is not allowed\n        ctx.op = \"none\";\n    } else {\n        ctx._source.data.roles.removeIf(entry -> entry.id.equals(params.roleEntryId));\n    if (params.containsKey(\"lastModifier\")) {\n        ctx._source.lastModifier = params.lastModifier;\n    }\n    if (params.containsKey(\"lastModified\")) {\n        ctx._source.lastModified = params.lastModified;\n    }\n}\n} else {\n   throw new Exception('Cannot find role.');\n}\n", params);
        try {
            updateResponse = this.executeUpdateRequest(collectionId, addEntityScript, "Was not able to delete role from collection with id [%s].");
        }
        catch (OpenSearchException e) {
            String errorMessage = String.format("Was not able to update role with id [%s] on collection with id [%s]. Collection or role does not exist!", roleEntryId, collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
        if (updateResponse.result() == Result.NoOp) {
            String message = String.format("Cannot delete last [%s] of collection [%s].", RoleType.MANAGER, collectionId);
            LOG.warn(message);
            throw new OptimizeCollectionConflictException(message);
        }
    }

    private Map<String, JsonData> constructParamsForRoleUpdateScript(String roleEntryId, String userId) {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("roleEntryId", JsonData.of((Object)roleEntryId));
        params.put("managerRole", JsonData.of((Object)RoleType.MANAGER.toString()));
        if (userId != null) {
            params.put("lastModifier", JsonData.of((Object)userId));
            params.put("lastModified", JsonData.of((Object)this.formatter.format(LocalDateUtil.getCurrentDateTime())));
        }
        return params;
    }
}

