/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.writer.AlertWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class AlertWriterOS
implements AlertWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AlertWriterOS.class);
    private final OptimizeOpenSearchClient osClient;

    public AlertWriterOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public AlertDefinitionDto createAlert(AlertDefinitionDto alertDefinitionDto) {
        LOG.debug("Writing new alert to OpenSearch");
        String id = IdGenerator.getNextId();
        alertDefinitionDto.setId(id);
        IndexRequest.Builder request = new IndexRequest.Builder().index("alert").id(id).document((Object)alertDefinitionDto).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(request);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = "Could not write alert to OpenSearch. Maybe the connection to OpenSearch got lost?";
            LOG.error("Could not write alert to OpenSearch. Maybe the connection to OpenSearch got lost?");
            throw new OptimizeRuntimeException("Could not write alert to OpenSearch. Maybe the connection to OpenSearch got lost?");
        }
        LOG.debug("alert with [{}] saved to opensearch", (Object)id);
        return alertDefinitionDto;
    }

    @Override
    public void updateAlert(AlertDefinitionDto alertUpdate) {
        LOG.debug("Updating alert with id [{}] in OpenSearch", (Object)alertUpdate.getId());
        UpdateRequest.Builder requestBuilder = RequestDSL.updateRequestBuilder((String)"alert").id(alertUpdate.getId()).doc((Object)alertUpdate).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        UpdateResponse response = this.osClient.update(requestBuilder, e -> {
            String errorMessage = "There were errors while updating alerts to OS.";
            LOG.error("There were errors while updating alerts to OS.", (Throwable)e);
            return "There were errors while updating alerts to OS." + e.getMessage();
        });
        if (response.shards().failed().intValue() > 0) {
            String errorMessage = String.format("Was not able to update alert with id [%s] and name [%s]. Error during the update in Opensearch.", alertUpdate.getId(), alertUpdate.getName());
            LOG.error(errorMessage);
            throw new OptimizeRuntimeException(errorMessage);
        }
    }

    @Override
    public void deleteAlert(String alertId) {
        LOG.debug("Deleting alert with id [{}]", (Object)alertId);
        DeleteRequest.Builder request = new DeleteRequest.Builder().index("alert").id(alertId).refresh(Refresh.True);
        DeleteResponse deleteResponse = this.osClient.delete(request, e -> {
            String error = String.format("Could not delete alert with id [%s]. Maybe Optimize is not connected to OpenSearch?", alertId);
            LOG.error(error, (Throwable)e);
            return "There were errors while deleting alerts to OS." + e.getMessage();
        });
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String error = String.format("Could not delete alert with id [%s]. Alert does not exist. Maybe it was already deleted by someone else?", alertId);
            LOG.error(error);
            throw new NotFoundException(error);
        }
    }

    @Override
    public void deleteAlerts(List<String> alertIds) {
        LOG.debug("Deleting alerts with ids: {}", alertIds);
        this.osClient.deleteByQuery(QueryDSL.ids(alertIds), true, new String[]{"alert"});
    }

    @Override
    public void writeAlertTriggeredStatus(boolean alertStatus, String alertId) {
        try {
            LOG.debug("Writing alert status for alert with id [{}] to OpenSearch", (Object)alertId);
            record AlertTriggered(boolean triggered) {
            }
            UpdateRequest.Builder request = new UpdateRequest.Builder().index("alert").id(alertId).doc((Object)new AlertTriggered(alertStatus)).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
            this.osClient.update(request, e -> {
                String errorMessage = String.format("Could not update status of alert with id [%s]. Maybe Optimize is not connected to OpenSearch?", alertId);
                LOG.error(errorMessage, (Throwable)e);
                return "There were errors while updating status alerts to OS." + e.getMessage();
            });
        }
        catch (Exception e2) {
            LOG.error("Can't update status of alert [{}]", (Object)alertId, (Object)e2);
        }
    }

    @Override
    public void deleteAlertsForReport(String reportId) {
        this.osClient.deleteByQuery(QueryDSL.term((String)"reportId", (String)reportId), true, new String[]{"alert"});
    }
}

