/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.service;

import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.context.VariableAggregationContextOS;
import io.camunda.optimize.service.db.os.report.service.DateAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.os.report.service.NumberVariableAggregationServiceOS;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.HistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.opensearch._types.aggregations.MultiTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.RangeBucket;
import org.opensearch.client.opensearch._types.aggregations.ReverseNestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class VariableAggregationServiceOS {
    public static final String NESTED_VARIABLE_AGGREGATION = "nestedVariables";
    public static final String NESTED_FLOWNODE_AGGREGATION = "nestedFlowNodes";
    public static final String VARIABLES_AGGREGATION = "variables";
    public static final String FILTERED_VARIABLES_AGGREGATION = "filteredVariables";
    public static final String FILTERED_INSTANCE_COUNT_AGGREGATION = "filteredInstCount";
    public static final String VARIABLES_INSTANCE_COUNT_AGGREGATION = "instCount";
    public static final String MISSING_VARIABLES_AGGREGATION = "missingVariables";
    public static final String VARIABLE_HISTOGRAM_AGGREGATION = "numberVariableHistogram";
    private final ConfigurationService configurationService;
    private final NumberVariableAggregationServiceOS numberVariableAggregationService;
    private final DateAggregationServiceOS dateAggregationService;
    private final MinMaxStatsServiceOS minMaxStatsService;

    public VariableAggregationServiceOS(ConfigurationService configurationService, NumberVariableAggregationServiceOS numberVariableAggregationService, DateAggregationServiceOS dateAggregationService, MinMaxStatsServiceOS minMaxStatsService) {
        this.configurationService = configurationService;
        this.numberVariableAggregationService = numberVariableAggregationService;
        this.dateAggregationService = dateAggregationService;
        this.minMaxStatsService = minMaxStatsService;
    }

    public Optional<Pair<String, Aggregation>> createVariableSubAggregation(VariableAggregationContextOS context) {
        context.setVariableRangeMinMaxStats(this.getVariableMinMaxStats(context));
        switch (context.getVariableType()) {
            case STRING: 
            case BOOLEAN: {
                TermsAggregation termsAggregation = new TermsAggregation.Builder().field(context.getNestedVariableValueFieldLabel()).size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit()).build();
                return Optional.of(Pair.of((Object)VARIABLES_AGGREGATION, (Object)new Aggregation.Builder().terms(termsAggregation).aggregations(context.getSubAggregations()).build()));
            }
            case DATE: {
                return this.createDateVariableAggregation(context);
            }
        }
        if (VariableType.getNumericTypes().contains(context.getVariableType())) {
            return this.numberVariableAggregationService.createNumberVariableAggregation(context);
        }
        return Optional.empty();
    }

    public Optional<Query> createVariableFilterQuery(VariableAggregationContextOS context) {
        if (VariableType.getNumericTypes().contains(context.getVariableType())) {
            return this.numberVariableAggregationService.getBaselineForNumberVariableAggregation(context).filter(baseLineValue -> !baseLineValue.isNaN()).map(baseLineValue -> QueryDSL.gteLte((String)context.getNestedVariableValueFieldLabel(), (Object)baseLineValue, (Object)context.getMaxVariableValue()));
        }
        return Optional.empty();
    }

    private Optional<Pair<String, Aggregation>> createDateVariableAggregation(VariableAggregationContextOS context) {
        DateAggregationContext dateAggContext = ((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)DateAggregationContextOS.builder().aggregateByDateUnit(context.getDateUnit())).dateField(context.getNestedVariableValueFieldLabel())).minMaxStats(context.getVariableRangeMinMaxStats())).timezone(context.getTimezone())).subAggregations(context.getSubAggregations())).dateAggregationName(VARIABLES_AGGREGATION)).filterContext(context.getFilterContext())).build();
        return this.dateAggregationService.createDateVariableAggregation((DateAggregationContextOS)dateAggContext);
    }

    public Map<String, Map<String, Aggregate>> retrieveResultBucketMap(FilterAggregate filteredParentAgg, Map<String, Map<String, Aggregate>> bucketMap, VariableType variableType, ZoneId timezone) {
        return VariableType.DATE.equals((Object)variableType) ? this.dateAggregationService.mapDateAggregationsToKeyAggregationMap(filteredParentAgg.aggregations(), timezone, VARIABLES_AGGREGATION) : bucketMap;
    }

    public Map<String, Map<String, Aggregate>> resultBucketMap(Aggregate aggregate) {
        if (aggregate.isMultiTerms()) {
            return aggregate.multiTerms().buckets().array().stream().collect(Collectors.toMap(MultiTermsBucket::keyAsString, MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1));
        }
        if (aggregate.isDateHistogram()) {
            return aggregate.dateHistogram().buckets().array().stream().collect(Collectors.toMap(DateHistogramBucket::keyAsString, MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1));
        }
        if (aggregate.isHistogram()) {
            return aggregate.histogram().buckets().array().stream().collect(Collectors.toMap(HistogramBucket::keyAsString, MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1));
        }
        if (aggregate.isSterms()) {
            return aggregate.sterms().buckets().array().stream().collect(Collectors.toMap(StringTermsBucket::key, MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1));
        }
        if (aggregate.isDateRange()) {
            return aggregate.dateRange().buckets().array().stream().collect(Collectors.toMap(RangeBucket::key, MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1));
        }
        throw new IllegalArgumentException("Unsupported aggregation type: " + aggregate._kind().name());
    }

    public Map<String, Aggregate> retrieveSubAggregationFromBucketMapEntry(Map.Entry<String, Map<String, Aggregate>> bucketMapEntry) {
        ReverseNestedAggregate reverseNested = bucketMapEntry.getValue().get(VARIABLES_INSTANCE_COUNT_AGGREGATION).reverseNested();
        if (reverseNested == null) {
            return bucketMapEntry.getValue();
        }
        Aggregate nestedFlowNodeAgg = (Aggregate)reverseNested.aggregations().get(NESTED_FLOWNODE_AGGREGATION);
        return nestedFlowNodeAgg == null ? reverseNested.aggregations() : ((Aggregate)nestedFlowNodeAgg.nested().aggregations().get("filteredFlowNodeAggregation")).filter().aggregations();
    }

    private MinMaxStatDto getVariableMinMaxStats(VariableAggregationContextOS context) {
        return this.getVariableMinMaxStats(context.getVariableType(), context.getVariableName(), context.getVariablePath(), context.getNestedVariableNameField(), context.getNestedVariableValueFieldLabel(), context.getIndexNames(), context.getBaseQueryForMinMaxStats());
    }

    public MinMaxStatDto getVariableMinMaxStats(VariableType variableType, String variableName, String variablePath, String nestedVariableNameField, String nestedVariableValueFieldLabel, String[] indexNames, Query baseQuery) {
        Query filterQuery = QueryDSL.term((String)nestedVariableNameField, (String)variableName);
        if (VariableType.getNumericTypes().contains(variableType)) {
            return this.minMaxStatsService.getSingleFieldMinMaxStats(baseQuery, indexNames, nestedVariableValueFieldLabel, variablePath, filterQuery);
        }
        if (VariableType.DATE.equals((Object)variableType)) {
            return this.minMaxStatsService.getSingleFieldMinMaxStats(baseQuery, indexNames, nestedVariableValueFieldLabel, "yyyy-MM-dd'T'HH:mm:ss.SSSZ", variablePath, filterQuery);
        }
        return new MinMaxStatDto(Double.NaN, Double.NaN);
    }
}

