/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.service;

import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.interpreter.util.FilterLimitedAggregationUtilOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.service.AbstractMinMaxStatsService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.StatsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StatsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class MinMaxStatsServiceOS
extends AbstractMinMaxStatsService {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxStatsServiceOS.class);
    private final OptimizeOpenSearchClient osClient;

    public MinMaxStatsServiceOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    public MinMaxStatDto getMinMaxDateRange(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String field) {
        return this.getMinMaxDateRangeForNestedField(context, query, indexNames, field, field, null, null);
    }

    public MinMaxStatDto getMinMaxDateRangeForCrossField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String firstField, String secondField) {
        return this.getMinMaxDateRangeForNestedField(context, query, indexNames, firstField, secondField, null, null);
    }

    public MinMaxStatDto getMinMaxDateRangeForNestedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String field, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return this.getMinMaxDateRangeForNestedField(context, query, indexNames, field, field, pathForNestedStatsAgg, filterQueryToWrapStatsWith);
    }

    public MinMaxStatDto getMinMaxNumberRangeForScriptedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, Script script) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getScriptedMinMaxStats(query, indexNames, null, script));
    }

    public MinMaxStatDto getMinMaxNumberRangeForNestedScriptedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String pathForNestedStatsAgg, Script script) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getScriptedMinMaxStats(query, indexNames, pathForNestedStatsAgg, script, null));
    }

    public MinMaxStatDto getMinMaxNumberRangeForNestedScriptedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String pathForNestedStatsAgg, Script script, Query filterQueryToWrapStatsWith) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getScriptedMinMaxStats(query, indexNames, pathForNestedStatsAgg, script, filterQueryToWrapStatsWith));
    }

    public MinMaxStatDto getScriptedMinMaxStats(Query query, String[] indexNames, String pathForNestedStatsAgg, Script script) {
        return this.getScriptedMinMaxStats(query, indexNames, pathForNestedStatsAgg, script, null);
    }

    private Pair<String, Aggregation> buildFilteredAggregation(Query filterQuery, Pair<String, Aggregation> basicAggregation) {
        return FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation("filterAggField1", filterQuery, basicAggregation);
    }

    private Pair<String, Aggregation> buildNestedAggregation(String nestedPath, Pair<String, Aggregation> aggregation) {
        return Pair.of((Object)"nestedAggField1", (Object)new Aggregation.Builder().nested(b -> b.path(nestedPath)).aggregations((String)aggregation.getKey(), (Aggregation)aggregation.getValue()).build());
    }

    private Pair<String, Aggregation> buildStatsAggregation(Script script, Query filterQuery, String nestedPath) {
        Pair<String, Aggregation> basicAggregation = Pair.of((Object)"statsAggField1", (Object)((StatsAggregation.Builder)new StatsAggregation.Builder().script(script)).build()._toAggregation());
        Pair<String, Aggregation> aggregation = filterQuery == null ? basicAggregation : this.buildFilteredAggregation(filterQuery, basicAggregation);
        return nestedPath == null ? aggregation : this.buildNestedAggregation(nestedPath, aggregation);
    }

    public MinMaxStatDto getScriptedMinMaxStats(Query query, String[] indexNames, String pathForNestedStatsAgg, Script script, Query filterQueryToWrapStatsWith) {
        SearchResponse response;
        Pair<String, Aggregation> statsAggregation = this.buildStatsAggregation(script, filterQueryToWrapStatsWith, pathForNestedStatsAgg);
        SearchRequest searchRequest = new SearchRequest.Builder().index(this.osClient.applyIndexPrefixes(indexNames)).query(query).source(QueryDSL.sourceExcluded()).aggregations((String)statsAggregation.getKey(), (Aggregation)statsAggregation.getValue()).size(Integer.valueOf(0)).build();
        try {
            response = this.osClient.searchUnsafe(searchRequest, Object.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not retrieve stats for script %s on indices %s", script.toString(), Arrays.toString(indexNames));
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (RuntimeException e) {
            return this.returnEmptyResultIfInstanceIndexNotFound(e, indexNames);
        }
        StatsAggregate minMaxStats = this.retrieveNestedWrappedStatsAggregation("nestedAggField1", "filterAggField1", "statsAggField1", response);
        return new MinMaxStatDto(minMaxStats.min(), minMaxStats.max());
    }

    public MinMaxStatDto getSingleFieldMinMaxStats(Query query, String[] indexNames, String field, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return this.getCrossFieldMinMaxStats(query, indexNames, field, field, null, pathForNestedStatsAgg, filterQueryToWrapStatsWith);
    }

    public MinMaxStatDto getSingleFieldMinMaxStats(Query query, String[] indexNames, String field, String format, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return this.getCrossFieldMinMaxStats(query, indexNames, field, field, format, pathForNestedStatsAgg, filterQueryToWrapStatsWith);
    }

    private MinMaxStatDto getMinMaxDateRangeForNestedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String firstField, String secondField, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getCrossFieldMinMaxStats(query, indexNames, firstField, secondField, "yyyy-MM-dd'T'HH:mm:ss.SSSZ", pathForNestedStatsAgg, filterQueryToWrapStatsWith));
    }

    private MinMaxStatDto getCrossFieldMinMaxStats(Query query, String[] indexNames, String firstField, String secondField, String format, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        SearchResponse response;
        Pair statsAggField1 = Pair.of((Object)"statsAggField1", (Object)this.createStatsAggregation(firstField, format));
        Pair statsAggField2 = Pair.of((Object)"statsAggField2", (Object)this.createStatsAggregation(secondField, format));
        if (filterQueryToWrapStatsWith != null) {
            statsAggField1 = FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation("filterAggField1", filterQueryToWrapStatsWith, (Pair<String, Aggregation>)statsAggField1);
            statsAggField2 = FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation("filterAggField2", filterQueryToWrapStatsWith, (Pair<String, Aggregation>)statsAggField2);
        }
        if (pathForNestedStatsAgg != null) {
            statsAggField1 = Pair.of((Object)"nestedAggField1", (Object)new Aggregation.Builder().nested(b -> b.path(pathForNestedStatsAgg)).aggregations((String)statsAggField1.getKey(), (Aggregation)statsAggField1.getValue()).build());
            statsAggField2 = Pair.of((Object)"nestedAggField2", (Object)new Aggregation.Builder().nested(b -> b.path(pathForNestedStatsAgg)).aggregations((String)statsAggField2.getKey(), (Aggregation)statsAggField2.getValue()).build());
        }
        SearchRequest searchRequest = new SearchRequest.Builder().index(this.osClient.applyIndexPrefixes(indexNames)).query(query).source(QueryDSL.sourceExcluded()).aggregations(Map.of((String)statsAggField1.getKey(), (Aggregation)statsAggField1.getValue(), (String)statsAggField2.getKey(), (Aggregation)statsAggField2.getValue())).size(Integer.valueOf(0)).build();
        try {
            response = this.osClient.searchUnsafe(searchRequest, Object.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not retrieve stats for firstField %s and secondField %s on index %s", firstField, secondField, Arrays.toString(indexNames));
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (RuntimeException e) {
            return this.returnEmptyResultIfInstanceIndexNotFound(e, indexNames);
        }
        return this.mapCrossFieldStatAggregationsToStatDto(response);
    }

    private Aggregation createStatsAggregation(String aggregationField, String format) {
        StatsAggregation.Builder builder = (StatsAggregation.Builder)new StatsAggregation.Builder().field(aggregationField);
        if (format != null) {
            builder.format(format);
        }
        return builder.build()._toAggregation();
    }

    private MinMaxStatDto mapCrossFieldStatAggregationsToStatDto(SearchResponse<?> response) {
        StatsAggregate minMaxStats1 = this.retrieveNestedWrappedStatsAggregation("nestedAggField1", "filterAggField1", "statsAggField1", response);
        StatsAggregate minMaxStats2 = this.retrieveNestedWrappedStatsAggregation("nestedAggField2", "filterAggField2", "statsAggField2", response);
        StatsAggregate minStats = minMaxStats1.min() < minMaxStats2.min() ? minMaxStats1 : minMaxStats2;
        StatsAggregate maxStats = minMaxStats1.max() > minMaxStats2.max() ? minMaxStats1 : minMaxStats2;
        return new MinMaxStatDto(minStats.min(), maxStats.max(), minStats.minAsString(), maxStats.maxAsString());
    }

    private StatsAggregate retrieveNestedWrappedStatsAggregation(String nestedAggName, String filterAggName, String statsAggName, SearchResponse<?> response) {
        Map unnestedAggs = response.aggregations().containsKey(nestedAggName) ? ((Aggregate)response.aggregations().get(nestedAggName)).nested().aggregations() : response.aggregations();
        Optional<Map<String, Aggregate>> unwrappedAggs = FilterLimitedAggregationUtilOS.unwrapFilterLimitedAggregations(filterAggName, unnestedAggs);
        return unwrappedAggs.orElse(unnestedAggs).get(statsAggName).stats();
    }
}

