/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.service;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.SingleReportConfigurationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.custom_buckets.CustomBucketDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.ComparisonOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.DurationFilterDataDto;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.DurationScriptUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.FilterLimitedAggregationUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.NumberHistogramAggregationUtilOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.report.service.DurationAggregationService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DurationAggregationServiceOS
extends DurationAggregationService {
    private final MinMaxStatsServiceOS minMaxStatsService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;

    public DurationAggregationServiceOS(MinMaxStatsServiceOS minMaxStatsService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter) {
        this.minMaxStatsService = minMaxStatsService;
        this.distributedByInterpreter = distributedByInterpreter;
    }

    public Optional<Pair<String, Aggregation>> createLimitedGroupByScriptedDurationAggregation(Query baseQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Script durationCalculationScript) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxNumberRangeForScriptedField(context, baseQuery, this.getIndexNames(context), durationCalculationScript);
        return this.createLimitedGroupByScriptedDurationAggregation(context, baseQuery, durationCalculationScript, minMaxStats, this::createProcessInstanceLimitingFilterQuery);
    }

    public Optional<Pair<String, Aggregation>> createLimitedGroupByScriptedUserTaskDurationAggregation(Query boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Script durationCalculationScript, UserTaskDurationTime userTaskDurationTime) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxNumberRangeForNestedScriptedField(context, boolQuery, this.getIndexNames(context), "flowNodeInstances", durationCalculationScript, Query.of(q -> q.bool(ModelElementFilterQueryUtilOS.createUserTaskFlowNodeTypeFilter().build())));
        return this.createLimitedGroupByScriptedDurationAggregation(context, boolQuery, durationCalculationScript, minMaxStats, (filterOperator, filterValueInMillis) -> this.createUserTaskLimitingFilterQuery((ComparisonOperator)filterOperator, userTaskDurationTime, (double)filterValueInMillis));
    }

    public Optional<Pair<String, Aggregation>> createLimitedGroupByScriptedEventDurationAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Script durationCalculationScript) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxNumberRangeForNestedScriptedField(context, query, this.getIndexNames(context), "flowNodeInstances", durationCalculationScript);
        return this.createLimitedGroupByScriptedDurationAggregation(context, query, durationCalculationScript, minMaxStats, this::createEventLimitingFilterQuery);
    }

    public List<CompositeCommandResult.GroupByResult> mapGroupByDurationResults(SearchResponse<RawResult> response, Map<String, Aggregate> parentSubAggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return Optional.ofNullable(parentSubAggregations).flatMap(FilterLimitedAggregationUtilOS::unwrapFilterLimitedAggregations).map(aggregations -> ((Aggregate)aggregations.get("durationHistogram")).histogram()).stream().flatMap(histogramAggregation -> histogramAggregation.buckets().array().stream().map(durationBucket -> {
            List<CompositeCommandResult.DistributedByResult> distributions = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)durationBucket.aggregations(), context);
            return CompositeCommandResult.GroupByResult.createGroupByResult(String.valueOf(durationBucket.key()), distributions);
        })).toList();
    }

    private Query createUserTaskLimitingFilterQuery(ComparisonOperator filterOperator, UserTaskDurationTime userTaskDurationTime, double filterValueInMillis) {
        return this.createLimitingFilterQuery(filterOperator, (long)filterValueInMillis, "flowNodeInstances." + userTaskDurationTime.getDurationFieldName(), "flowNodeInstances.startDate", true);
    }

    private Optional<Pair<String, Aggregation>> createLimitedGroupByScriptedDurationAggregation(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery, Script durationCalculationScript, MinMaxStatDto minMaxStats, BiFunction<ComparisonOperator, Double, Query> limitingFilterCreator) {
        double maxValueInMillis;
        if (minMaxStats.isEmpty()) {
            return Optional.empty();
        }
        SingleReportConfigurationDto reportConfigurationDto = context.getReportData().getConfiguration();
        CustomBucketDto customBucketDto = reportConfigurationDto.getCustomBucket();
        double minValueInMillis = this.getMinValueInMillis(minMaxStats, customBucketDto);
        if (minValueInMillis > (maxValueInMillis = minMaxStats.getMax())) {
            return Optional.empty();
        }
        double intervalInMillis = this.getIntervalInMillis(minValueInMillis, maxValueInMillis, customBucketDto);
        Query limitingFilter = QueryDSL.filter((Query[])new Query[]{limitingFilterCreator.apply(ComparisonOperator.GREATER_THAN_EQUALS, minValueInMillis)});
        Pair<String, Aggregation> histogramAggregation = NumberHistogramAggregationUtilOS.generateHistogramFromScript("durationHistogram", intervalInMillis, minValueInMillis, durationCalculationScript, maxValueInMillis, this.distributedByInterpreter.createAggregations(context, baseQuery));
        return Optional.of(FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation(limitingFilter, histogramAggregation));
    }

    private Query createProcessInstanceLimitingFilterQuery(ComparisonOperator filterOperator, double filterValueInMillis) {
        return this.createLimitingFilterQuery(filterOperator, (long)filterValueInMillis, "duration", "startDate", false);
    }

    private Query createLimitingFilterQuery(ComparisonOperator filterOperator, long filterValueInMillis, String durationFieldName, String referenceDateFieldName, boolean includeNull) {
        return (Query)new Query.Builder().script(b -> b.script(DurationScriptUtilOS.getDurationFilterScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), durationFieldName, referenceDateFieldName, DurationFilterDataDto.builder().operator(filterOperator).unit(FILTER_UNIT).value(Long.valueOf(filterValueInMillis)).includeNull(includeNull).build()))).build();
    }

    private Query createEventLimitingFilterQuery(ComparisonOperator filterOperator, double filterValueInMillis) {
        return this.createLimitingFilterQuery(filterOperator, (long)filterValueInMillis, "flowNodeInstances.totalDurationInMs", "flowNodeInstances.startDate", false);
    }
}

