/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.service;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.filter.ProcessQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.report.filter.util.DateHistogramFilterUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.AggregateByDateUnitMapperOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.FilterLimitedAggregationUtilOS;
import io.camunda.optimize.service.db.report.interpreter.util.AggregateByDateUnitMapper;
import io.camunda.optimize.service.db.report.service.DateAggregationService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramAggregation;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.DateRangeExpression;
import org.opensearch.client.opensearch._types.aggregations.FiltersAggregation;
import org.opensearch.client.opensearch._types.aggregations.HistogramOrder;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.opensearch._types.aggregations.RangeBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DateAggregationServiceOS
extends DateAggregationService {
    private static final String DATE_AGGREGATION = "dateAggregation";
    private final DateTimeFormatter dateTimeFormatter;

    public DateAggregationServiceOS(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public Optional<Pair<String, Aggregation>> createProcessInstanceDateAggregation(DateAggregationContextOS context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return Optional.of(this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createFilterLimitedProcessDateHistogramWithSubAggregation));
        }
        return Optional.of(this.createFilterLimitedProcessDateHistogramWithSubAggregation(context));
    }

    public Optional<Pair<String, Aggregation>> createModelElementDateAggregation(DateAggregationContextOS context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        Pair<String, Aggregation> agg = AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit()) ? this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createFilterLimitedModelElementDateHistogramWithSubAggregation) : this.createFilterLimitedModelElementDateHistogramWithSubAggregation(context);
        return Optional.of(agg);
    }

    public Optional<Pair<String, Aggregation>> createDateVariableAggregation(DateAggregationContextOS context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return Optional.of(this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createDateHistogramWithSubAggregation));
        }
        return Optional.of(this.createDateHistogramWithSubAggregation(context));
    }

    public Optional<Pair<String, Aggregation>> createDecisionEvaluationDateAggregation(DateAggregationContextOS context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return Optional.ofNullable(this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createFilterLimitedDecisionDateHistogramWithSubAggregation));
        }
        return Optional.of(this.createFilterLimitedDecisionDateHistogramWithSubAggregation(context));
    }

    public Optional<Pair<String, Aggregation>> createRunningDateAggregation(DateAggregationContextOS context) {
        if (!context.getMinMaxStats().isMinValid()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit()) && !context.getMinMaxStats().isValidRange()) {
            context.setAggregateByDateUnit(AggregateByDateUnit.MONTH);
        }
        return Optional.of(this.createRunningDateFilterAggregations(context));
    }

    public Map<String, Map<String, Aggregate>> mapDateAggregationsToKeyAggregationMap(Map<String, Aggregate> aggregations, ZoneId timezone) {
        return this.mapDateAggregationsToKeyAggregationMap(aggregations, timezone, DATE_AGGREGATION);
    }

    private Map<String, Map<String, Aggregate>> multiBucketAggregation(Aggregate aggregate) {
        if (aggregate.isDateHistogram()) {
            return aggregate.dateHistogram().buckets().array().stream().collect(Collectors.toMap(DateHistogramBucket::key, MultiBucketBase::aggregations));
        }
        if (aggregate.isDateRange()) {
            return aggregate.dateRange().buckets().array().stream().collect(Collectors.toMap(RangeBucket::key, MultiBucketBase::aggregations));
        }
        throw new UnsupportedOperationException("Unsupported multi bucket aggregation type " + aggregate._kind().name());
    }

    private String formatToCorrectTimezoneWithFallback(String dateTime, ZoneId timezone, DateTimeFormatter formatter) {
        try {
            return TimeZoneUtil.formatToCorrectTimezone(dateTime, timezone, formatter);
        }
        catch (Exception e) {
            try {
                dateTime = Instant.ofEpochMilli(Long.parseLong(dateTime)).atZone(ZoneId.of("UTC")).format(formatter);
                return TimeZoneUtil.formatToCorrectTimezone(dateTime, timezone, formatter);
            }
            catch (Exception e2) {
                throw new OptimizeRuntimeException("Failed to parse date time: " + dateTime, (Throwable)e2);
            }
        }
    }

    public Map<String, Map<String, Aggregate>> mapDateAggregationsToKeyAggregationMap(Map<String, Aggregate> aggregations, ZoneId timezone, String aggregationName) {
        return this.multiBucketAggregation(aggregations.get(aggregationName)).entrySet().stream().map(entry -> Pair.of((Object)this.formatToCorrectTimezoneWithFallback((String)entry.getKey(), timezone, this.dateTimeFormatter), (Object)((Map)entry.getValue()))).sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    private Pair<String, Aggregation> createDateHistogramAggregation(DateAggregationContextOS context, Consumer<DateHistogramAggregation.Builder> dateHistogramAggregationBuilderModification) {
        DateHistogramAggregation.Builder dateHistogramAggregationBuilder = new DateHistogramAggregation.Builder().order(b -> b.key(SortOrder.Desc)).field(context.getDateField()).calendarInterval(AggregateByDateUnitMapperOS.mapToCalendarInterval(context.getAggregateByDateUnit())).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ").timeZone(context.getTimezone().toString());
        if (context.isExtendBoundsToMinMaxStats() && context.getMinMaxStats().isMaxValid() && context.getMinMaxStats().isMinValid()) {
            dateHistogramAggregationBuilder.extendedBounds(b -> b.min((Object)AggregationDSL.fieldDateMath((double)context.getMinMaxStats().getMin())).max((Object)AggregationDSL.fieldDateMath((double)context.getMinMaxStats().getMax())));
        }
        dateHistogramAggregationBuilderModification.accept(dateHistogramAggregationBuilder);
        return Pair.of((Object)context.getDateAggregationName().orElse(DATE_AGGREGATION), (Object)new Aggregation.Builder().dateHistogram(dateHistogramAggregationBuilder.build()).aggregations(context.getSubAggregations()).build());
    }

    private Pair<String, Aggregation> createDateHistogramWithSubAggregation(DateAggregationContextOS context) {
        return Pair.of((Object)context.getDateAggregationName().orElse(DATE_AGGREGATION), (Object)new Aggregation.Builder().dateHistogram(b -> b.order(HistogramOrder.of(b1 -> b1.key(SortOrder.Desc))).field(context.getDateField()).calendarInterval(AggregateByDateUnitMapperOS.mapToCalendarInterval(context.getAggregateByDateUnit())).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ").timeZone(context.getTimezone().toString())).aggregations(context.getSubAggregations()).build());
    }

    private Pair<String, Aggregation> createRunningDateFilterAggregations(DateAggregationContextOS context) {
        AggregateByDateUnit unit = context.getAggregateByDateUnit();
        ZonedDateTime startOfFirstBucket = this.truncateToUnit(context.getEarliestDate(), unit);
        ZonedDateTime endOfLastBucket = AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit()) ? context.getLatestDate() : this.truncateToUnit(context.getLatestDate(), context.getAggregateByDateUnit()).plus(1L, AggregateByDateUnitMapper.mapToChronoUnit((AggregateByDateUnit)unit));
        Duration automaticIntervalDuration = DateAggregationServiceOS.getDateHistogramIntervalDurationFromMinMax(context.getMinMaxStats());
        HashMap<String, Query> filters = new HashMap<String, Query>();
        ZonedDateTime currentBucketStart = startOfFirstBucket;
        while (currentBucketStart.isBefore(endOfLastBucket)) {
            String startAsString = this.dateTimeFormatter.format(currentBucketStart.toOffsetDateTime());
            String endAsString = this.dateTimeFormatter.format(this.getEndOfBucket(currentBucketStart, unit, automaticIntervalDuration).toOffsetDateTime());
            Query query = QueryDSL.and((Query[])new Query[]{QueryDSL.lt((String)context.getDateField(), (Object)endAsString), QueryDSL.or((Query[])new Query[]{QueryDSL.gte((String)context.getRunningDateReportEndDateField(), (Object)startAsString), QueryDSL.not((Query[])new Query[]{QueryDSL.exists((String)context.getRunningDateReportEndDateField())})})});
            filters.put(startAsString, query);
            currentBucketStart = this.getEndOfBucket(currentBucketStart, unit, automaticIntervalDuration);
        }
        return Pair.of((Object)"filterLimitedAggregation", (Object)AggregationDSL.withSubaggregations((FiltersAggregation)AggregationDSL.filtersAggregation(filters), context.getSubAggregations()));
    }

    private Pair<String, Aggregation> createAutomaticIntervalAggregationOrFallbackToMonth(DateAggregationContextOS context, Function<DateAggregationContextOS, Pair<String, Aggregation>> defaultAggregationCreator) {
        return this.createAutomaticIntervalAggregationWithSubAggregation(context).map(automaticIntervalAggregation -> FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation(QueryDSL.matchAll(), (Pair<String, Aggregation>)automaticIntervalAggregation)).orElse(this.defaultAggregation(context, defaultAggregationCreator));
    }

    private Pair<String, Aggregation> defaultAggregation(DateAggregationContextOS context, Function<DateAggregationContextOS, Pair<String, Aggregation>> defaultAggregationCreator) {
        context.setAggregateByDateUnit(AggregateByDateUnit.MONTH);
        return defaultAggregationCreator.apply(context);
    }

    private Optional<Pair<String, Aggregation>> createAutomaticIntervalAggregationWithSubAggregation(DateAggregationContextOS context) {
        ZonedDateTime nextStart;
        if (!context.getMinMaxStats().isValidRange()) {
            return Optional.empty();
        }
        ZonedDateTime min = context.getEarliestDate();
        ZonedDateTime max = context.getLatestDate();
        Duration intervalDuration = DateAggregationServiceOS.getDateHistogramIntervalDurationFromMinMax(context.getMinMaxStats());
        ZonedDateTime start = min;
        ArrayList<DateRangeExpression> ranges = new ArrayList<DateRangeExpression>();
        do {
            boolean isLast = (nextStart = start.plus(intervalDuration)).isAfter(max) || nextStart.isEqual(max);
            ZonedDateTime end = isLast ? nextStart.plus(1L, ChronoUnit.MILLIS) : nextStart;
            DateRangeExpression range = new DateRangeExpression.Builder().key(this.dateTimeFormatter.format(start)).from(AggregationDSL.fieldDateMath((String)this.dateTimeFormatter.format(start))).to(AggregationDSL.fieldDateMath((String)this.dateTimeFormatter.format(end))).build();
            ranges.add(range);
        } while ((start = nextStart).isBefore(max));
        String aggregationName = context.getDateAggregationName().orElse(DATE_AGGREGATION);
        Aggregation rangeAgg = new Aggregation.Builder().aggregations(context.getSubAggregations()).dateRange(b -> b.field(context.getDateField()).timeZone(min.getZone().toString()).ranges(ranges)).build();
        return Optional.of(Pair.of((Object)aggregationName, (Object)rangeAgg));
    }

    private Pair<String, Aggregation> createFilterLimitedDecisionDateHistogramWithSubAggregation(DateAggregationContextOS context) {
        Pair<String, Aggregation> dateHistogramAggregation = this.createDateHistogramAggregation(context, builder -> DateHistogramFilterUtilOS.extendBounds(context, this.dateTimeFormatter).ifPresent(arg_0 -> ((DateHistogramAggregation.Builder)builder).extendedBounds(arg_0)));
        List<Query> limitFilterQuery = DateHistogramFilterUtilOS.createDecisionDateHistogramLimitingFilter(context);
        return FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation(QueryDSL.filter(limitFilterQuery), dateHistogramAggregation);
    }

    private Pair<String, Aggregation> createFilterLimitedProcessDateHistogramWithSubAggregation(DateAggregationContextOS context) {
        Pair<String, Aggregation> dateHistogramAggregation = this.createDateHistogramAggregation(context, this.extendBoundsConsumer(context));
        Query limitFilterQuery = DateAggregationServiceOS.createProcessDateHistogramLimitingFilterQuery(context);
        return FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation(limitFilterQuery, dateHistogramAggregation);
    }

    private Consumer<DateHistogramAggregation.Builder> extendBoundsConsumer(DateAggregationContextOS context) {
        return builder -> {
            List<DateFilterDataDto<?>> dateFilters;
            ProcessQueryFilterEnhancerOS queryFilterEnhancer = context.getProcessQueryFilterEnhancer();
            List<Object> list = dateFilters = context.isStartDateAggregation() ? queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceStartDateFilterDto.class) : queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceEndDateFilterDto.class);
            if (!dateFilters.isEmpty()) {
                DateHistogramFilterUtilOS.getExtendedBoundsFromDateFilters(dateFilters, this.dateTimeFormatter, context).ifPresent(arg_0 -> ((DateHistogramAggregation.Builder)builder).extendedBounds(arg_0));
            }
        };
    }

    private static Query createProcessDateHistogramLimitingFilterQuery(DateAggregationContextOS context) {
        ProcessQueryFilterEnhancerOS queryFilterEnhancer = context.getProcessQueryFilterEnhancer();
        List<DateFilterDataDto<?>> startDateFilters = queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceStartDateFilterDto.class);
        List<DateFilterDataDto<?>> endDateFilters = queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceEndDateFilterDto.class);
        List<Query> limitFilterQueries = context.isStartDateAggregation() ? (!endDateFilters.isEmpty() && startDateFilters.isEmpty() ? DateHistogramFilterUtilOS.createFilterBoolQueryBuilder(endDateFilters, queryFilterEnhancer.getInstanceEndDateQueryFilter(), context.getFilterContext()) : DateHistogramFilterUtilOS.createFilterBoolQueryBuilder(startDateFilters, queryFilterEnhancer.getInstanceStartDateQueryFilter(), context.getFilterContext())) : (endDateFilters.isEmpty() && !startDateFilters.isEmpty() ? DateHistogramFilterUtilOS.createFilterBoolQueryBuilder(startDateFilters, queryFilterEnhancer.getInstanceStartDateQueryFilter(), context.getFilterContext()) : DateHistogramFilterUtilOS.createFilterBoolQueryBuilder(endDateFilters, queryFilterEnhancer.getInstanceEndDateQueryFilter(), context.getFilterContext()));
        return QueryDSL.filter(limitFilterQueries);
    }

    private Pair<String, Aggregation> createFilterLimitedModelElementDateHistogramWithSubAggregation(DateAggregationContextOS context) {
        Pair<String, Aggregation> dateHistogramAggregation = this.createDateHistogramAggregation(context, x -> {});
        Query limitFilterQuery = DateHistogramFilterUtilOS.createModelElementDateHistogramLimitingFilterQueryFor(context, this.dateTimeFormatter);
        return FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation(limitFilterQuery, dateHistogramAggregation);
    }
}

