/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.process.duration;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.process_part.ProcessPartDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.report.aggregations.AggregationStrategyOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.util.ProcessPartQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.duration.ProcessViewInstanceDurationInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.aggregations.AggregationStrategy;
import io.camunda.optimize.service.db.report.interpreter.view.process.duration.ProcessViewDurationInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessViewInstanceDurationOnProcessPartInterpreterOS
extends ProcessViewInstanceDurationInterpreterOS {
    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        ProcessPartDto processPart = ProcessViewDurationInterpreterHelper.getProcessPart(context);
        return ProcessPartQueryUtilOS.createProcessPartAggregation(processPart.getStart(), processPart.getEnd(), this.getAggregationStrategies(context.getReportData()).stream().map(AggregationStrategy::getAggregationType).collect(Collectors.toList()));
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List aggregationStrategies = this.getAggregationStrategies(context.getReportData());
        Function<AggregationStrategyOS, Double> measureExtractor = aggregationStrategy -> ProcessPartQueryUtilOS.getProcessPartAggregationResult(aggs, aggregationStrategy.getAggregationType());
        return ProcessViewDurationInterpreterHelper.retrieveResult(aggregationStrategies, measureExtractor);
    }

    @Override
    public BoolQuery.Builder adjustQuery(BoolQuery.Builder queryBuilder, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        super.adjustQuery(queryBuilder, context);
        ProcessPartDto processPart = ProcessViewDurationInterpreterHelper.getProcessPart(context);
        ProcessPartQueryUtilOS.addProcessPartQuery(queryBuilder, processPart.getStart(), processPart.getEnd());
        return queryBuilder;
    }
}

