/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.process;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessViewInstancePercentageInterpreterOS
implements ProcessViewInterpreterOS {
    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_INSTANCE_PERCENTAGE);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return Map.of("_frequency", AggregationDSL.filterAggregation((Query)QueryDSL.matchAll()));
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        long unfilteredTotalInstanceCount = context.getUnfilteredTotalInstanceCount();
        if (unfilteredTotalInstanceCount == 0L) {
            return this.createViewResult(null);
        }
        FilterAggregate frequency = aggregations.get("_frequency").filter();
        return this.createViewResult((double)frequency.docCount() / (double)unfilteredTotalInstanceCount * 100.0);
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.createViewResult(0.0);
    }

    private CompositeCommandResult.ViewResult createViewResult(Double value) {
        return CompositeCommandResult.ViewResult.builder().viewMeasure(CompositeCommandResult.ViewMeasure.builder().value(value).build()).build();
    }
}

