/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.util;

import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.report.interpreter.util.AbstractProcessPartQueryUtil;
import io.camunda.optimize.util.types.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringSubstitutor;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.ScriptedMetricAggregate;
import org.opensearch.client.opensearch._types.aggregations.ScriptedMetricAggregation;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public final class ProcessPartQueryUtilOS
extends AbstractProcessPartQueryUtil {
    private ProcessPartQueryUtilOS() {
    }

    public static Double getProcessPartAggregationResult(Map<String, Aggregate> aggs, AggregationDto aggregationType) {
        NestedAggregate nested = aggs.get("nestedAggregation").nested();
        ScriptedMetricAggregate scriptedMetric = ((Aggregate)nested.aggregations().get(ProcessPartQueryUtilOS.getScriptAggregationName(aggregationType))).scriptedMetric();
        try {
            return (Double)scriptedMetric.value().to(Double.class);
        }
        catch (IllegalStateException i) {
            return ReportConstants.NO_DATA_AVAILABLE_RESULT;
        }
    }

    public static void addProcessPartQuery(BoolQuery.Builder queryBuilder, String startFlowNodeId, String endFlowNodeId) {
        String termPath = "flowNodeInstances.flowNodeId";
        queryBuilder.must(QueryDSL.nested((String)"flowNodeInstances", (Query)QueryDSL.term((String)"flowNodeInstances.flowNodeId", (String)startFlowNodeId), (ChildScoreMode)ChildScoreMode.None), new Query[]{QueryDSL.nested((String)"flowNodeInstances", (Query)QueryDSL.term((String)"flowNodeInstances.flowNodeId", (String)endFlowNodeId), (ChildScoreMode)ChildScoreMode.None)});
    }

    public static Map<String, Aggregation> createProcessPartAggregation(String startFlowNodeId, String endFlowNodeId, List<AggregationDto> aggregationTypes) {
        Function<AggregationDto, Aggregation> buildScriptedMetricAgg = aggregationDto -> {
            Map<String, JsonData> params = Map.of("startFlowNodeId", JsonData.of((Object)startFlowNodeId), "endFlowNodeId", JsonData.of((Object)endFlowNodeId), "aggregationType", JsonData.of((Object)aggregationDto.getType().getId()));
            return new ScriptedMetricAggregation.Builder().initScript(ProcessPartQueryUtilOS.createInitScript()).mapScript(ProcessPartQueryUtilOS.createMapScript()).combineScript(ProcessPartQueryUtilOS.createCombineScript()).reduceScript(ProcessPartQueryUtilOS.getReduceScript()).params(params).build()._toAggregation();
        };
        Map aggregations = (Map)aggregationTypes.stream().map(aggDto -> Pair.of((Object)ProcessPartQueryUtilOS.getScriptAggregationName(aggDto), (Object)((Aggregation)buildScriptedMetricAgg.apply((AggregationDto)aggDto)))).collect(MapUtil.pairCollector());
        Aggregation nestedFlowNodeAggregation = new Aggregation.Builder().nested(n -> n.path("flowNodeInstances")).aggregations(aggregations).build();
        return Map.of("nestedAggregation", nestedFlowNodeAggregation);
    }

    private static Script createInitScript() {
        return QueryDSL.script((String)"state.procInstIdToStartDates = new HashMap();state.procInstIdToEndDates = new HashMap();");
    }

    private static Script createMapScript() {
        StringSubstitutor substitutor = new StringSubstitutor((Map)ImmutableMap.builder().put((Object)"flowNodeProcessInstanceIdField", (Object)"flowNodeInstances.processInstanceId").put((Object)"flowNodeIdField", (Object)"flowNodeInstances.flowNodeId").put((Object)"flowNodeStartDateField", (Object)"flowNodeInstances.startDate").put((Object)"flowNodeEndDateField", (Object)"flowNodeInstances.endDate").build());
        return QueryDSL.script((String)substitutor.replace("def processInstanceId = doc['${flowNodeProcessInstanceIdField}'].value;if(doc['${flowNodeIdField}'].value == params.startFlowNodeId && doc['${flowNodeStartDateField}'].size() != 0 && doc['${flowNodeStartDateField}'].value != null && doc['${flowNodeStartDateField}'].value.toInstant().toEpochMilli() != 0) {long startDateInMillis = doc['${flowNodeStartDateField}'].value.toInstant().toEpochMilli();state.procInstIdToStartDates.putIfAbsent(processInstanceId, new ArrayList());state.procInstIdToStartDates.get(processInstanceId).add(startDateInMillis);} else if(doc['${flowNodeIdField}'].value == params.endFlowNodeId && doc['${flowNodeEndDateField}'].size() != 0 && doc['${flowNodeEndDateField}'].value != null && doc['${flowNodeEndDateField}'].value.toInstant().toEpochMilli() != 0) {long endDateInMillis = doc['${flowNodeEndDateField}'].value.toInstant().toEpochMilli();state.procInstIdToEndDates.putIfAbsent(processInstanceId, new ArrayList());state.procInstIdToEndDates.get(processInstanceId).add(endDateInMillis);}"));
    }

    private static Script createCombineScript() {
        return QueryDSL.script((String)"double sum = 0.0;long count = 0;double min = Double.MAX_VALUE;double max = Double.MIN_VALUE;for (procInstIdToStartDatesEntry in state.procInstIdToStartDates.entrySet()) {  def endDates = state.procInstIdToEndDates.getOrDefault(procInstIdToStartDatesEntry.getKey(), new ArrayList());def startDates = procInstIdToStartDatesEntry.getValue();if (!startDates.isEmpty() && !endDates.isEmpty()) {long minStartDate = startDates.stream().min(Long::compareTo).get(); List endDatesLargerMinStartDate = endDates.stream().filter(e -> e >= minStartDate).collect(Collectors.toList());if (!endDatesLargerMinStartDate.isEmpty()) {long closestEndDate = endDatesLargerMinStartDate.stream().min(Comparator.comparingDouble(v -> Math.abs(v - minStartDate))).get();double duration = closestEndDate - minStartDate;min = duration < min? duration : min;max = duration > max? duration : max;sum += duration;count += 1;}}}Map result = new HashMap();result.put('aggregationType', params.aggregationType);result.put('sum', sum);result.put('count', count);result.put('min', min);result.put('max', max);return result;");
    }

    private static Script getReduceScript() {
        return QueryDSL.script((String)"if (states == null || states.isEmpty()) {return null;}double sum = 0; long count = 0; double min = Double.MAX_VALUE;double max = Double.MIN_VALUE;def aggregationType = 'avg';for (a in states) { if (a != null) {sum += a.get('sum');count += a.get('count');min = a.get('min') < min? a.get('min') : min;max = a.get('max') > max? a.get('max') : max;}}if (count == 0) {return null;}if (params.aggregationType == 'avg') {return sum / count;} else if (params.aggregationType == 'min') {return min;} else if (params.aggregationType == 'max') {return max;} else if (params.aggregationType == 'sum') {return sum;} else {Debug.explain('Aggregation type ' + params.aggregationType + ' is not supported!');}");
    }
}

