/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.plan.process;

import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.ProcessQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.GroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.ProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.plan.AbstractExecutionPlanInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.plan.process.ProcessExecutionPlanInterpreterOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessInstanceIndexOS;
import io.camunda.optimize.service.db.os.util.DefinitionQueryUtilOS;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public abstract class AbstractProcessExecutionPlanInterpreterOS
extends AbstractExecutionPlanInterpreterOS<ProcessReportDataDto, ProcessExecutionPlan>
implements ProcessExecutionPlanInterpreterOS {
    protected abstract ProcessDefinitionReader getProcessDefinitionReader();

    protected abstract ProcessQueryFilterEnhancerOS getQueryFilterEnhancer();

    @Override
    public Optional<MinMaxStatDto> getGroupByMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        GroupByInterpreterOS groupByInterpreterOS = this.getGroupByInterpreter();
        if (groupByInterpreterOS instanceof ProcessGroupByInterpreterOS) {
            ProcessGroupByInterpreterOS processGroupByInterpreter = (ProcessGroupByInterpreterOS)groupByInterpreterOS;
            return processGroupByInterpreter.getMinMaxStats(context, this.baseQueryBuilder(context).build().toQuery());
        }
        return Optional.empty();
    }

    @Override
    public BoolQuery.Builder baseQueryBuilder(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map dateFiltersByDefinition = context.getReportData().groupFiltersByDefinitionIdentifier();
        List allDefinitionsFilters = dateFiltersByDefinition.getOrDefault("all", Collections.emptyList());
        List additionalFiltersStream = context.getReportData().getAdditionalFiltersForReportType();
        ArrayList filters = new ArrayList(allDefinitionsFilters);
        filters.addAll(additionalFiltersStream);
        List<Query> filterQueries = this.getQueryFilterEnhancer().filterQueries(filters, context.getFilterContext());
        return this.buildDefinitionBaseQueryForFilters(context, dateFiltersByDefinition, filterQueries);
    }

    @Override
    protected String[] getIndexNames(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (context.isMultiIndexAlias() || context.getReportData().isManagementReport()) {
            return this.getMultiIndexAlias();
        }
        return InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData());
    }

    @Override
    protected String[] getMultiIndexAlias() {
        return new String[]{"process-instance"};
    }

    @Override
    protected BoolQuery.Builder unfilteredBaseQueryBuilder(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map<String, List<ProcessFilterDto<?>>> instanceLevelDateFiltersByDefinitionKey = this.getInstanceLevelDateFiltersByDefinitionKey(context);
        List<ProcessFilterDto<?>> filters = instanceLevelDateFiltersByDefinitionKey.getOrDefault("all", Collections.emptyList());
        List<Query> filterQueries = this.getQueryFilterEnhancer().filterQueries(filters, context.getFilterContext());
        return this.buildDefinitionBaseQueryForFilters(context, instanceLevelDateFiltersByDefinitionKey, filterQueries);
    }

    private BoolQuery.Builder buildDefinitionBaseQueryForFilters(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Map<String, List<ProcessFilterDto<?>>> filtersByDefinition, List<Query> filterQueries) {
        return context.getReportData().getDefinitions().isEmpty() && context.getReportData().isManagementReport() ? new BoolQuery.Builder().filter(QueryDSL.not((Query[])new Query[]{QueryDSL.matchAll()}), new Query[0]) : new BoolQuery.Builder().minimumShouldMatch("1").should(this.multiDefinitionFilterQueries(context, filtersByDefinition)).filter(filterQueries);
    }

    private List<Query> multiDefinitionFilterQueries(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Map<String, List<ProcessFilterDto<?>>> filtersByDefinition) {
        return context.getReportData().getDefinitions().stream().map(definitionDto -> {
            List<ProcessFilterDto<?>> filters = filtersByDefinition.getOrDefault(definitionDto.getIdentifier(), List.of());
            return this.createDefinitionQuery((ReportDataDefinitionDto)definitionDto, filters, context.getFilterContext());
        }).toList();
    }

    private Query createDefinitionQuery(ReportDataDefinitionDto definitionDto, List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        List<Query> filterQueries = this.getQueryFilterEnhancer().filterQueries(filters, filterContext);
        return DefinitionQueryUtilOS.createDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), (AbstractInstanceIndex)new ProcessInstanceIndexOS(definitionDto.getKey()), this.getProcessDefinitionReader()::getLatestVersionToKey).filter(filterQueries).build().toQuery();
    }
}

