/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.none;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.filter.util.IncidentFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.ProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.SingleBucketAggregateBase;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessIncidentGroupByNoneInterpreterOS
extends AbstractProcessGroupByInterpreterOS
implements ProcessGroupByInterpreterOS {
    private static final String NESTED_INCIDENT_AGGREGATION = "incidentAggregation";
    private static final String FILTERED_INCIDENT_AGGREGATION = "filteredIncidentAggregation";
    private final ProcessViewInterpreterFacadeOS viewInterpreter;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final DefinitionService definitionService;

    public ProcessIncidentGroupByNoneInterpreterOS(ProcessViewInterpreterFacadeOS viewInterpreter, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, DefinitionService definitionService) {
        this.viewInterpreter = viewInterpreter;
        this.distributedByInterpreter = distributedByInterpreter;
        this.definitionService = definitionService;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_INCIDENT_GROUP_BY_NONE);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map<String, Aggregation> distributedByAggs = this.getDistributedByInterpreter().createAggregations(context, query);
        Aggregation filteredIncidentAggregation = new Aggregation.Builder().filter(IncidentFilterQueryUtilOS.createIncidentAggregationFilterQuery(context.getReportData(), this.definitionService)).aggregations(distributedByAggs).build();
        Aggregation nestedAggregation = new Aggregation.Builder().nested(n -> n.path("incidents")).aggregations(FILTERED_INCIDENT_AGGREGATION, filteredIncidentAggregation).build();
        return Map.of(NESTED_INCIDENT_AGGREGATION, nestedAggregation);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        this.getNestedIncidentsAggregation(response).ifPresent(nestedIncidents -> {
            List<CompositeCommandResult.DistributedByResult> distributions = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)nestedIncidents.aggregations(), context);
            CompositeCommandResult.GroupByResult groupByResult = CompositeCommandResult.GroupByResult.createGroupByNone(distributions);
            compositeCommandResult.setGroup(groupByResult);
        });
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }

    private Optional<FilterAggregate> getNestedIncidentsAggregation(SearchResponse<RawResult> response) {
        return this.getFilteredIncidentsAggregation(response).map(SingleBucketAggregateBase::aggregations).map(aggs -> ((Aggregate)aggs.get(FILTERED_INCIDENT_AGGREGATION)).filter());
    }

    private Optional<NestedAggregate> getFilteredIncidentsAggregation(SearchResponse<RawResult> response) {
        return Optional.ofNullable(response.aggregations()).map(aggs -> ((Aggregate)aggs.get(NESTED_INCIDENT_AGGREGATION)).nested());
    }
}

