/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.identity;

import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.process.identity.ProcessGroupByIdentityInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractProcessGroupByIdentityInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    private static final String GROUP_BY_IDENTITY_TERMS_AGGREGATION = "identities";
    private static final String FLOW_NODES_AGGREGATION = "flowNodeInstances";
    private static final String USER_TASKS_AGGREGATION = "userTasks";
    private static final String FILTERED_USER_TASKS_AGGREGATION = "filteredUserTasks";
    private static final String GROUP_BY_IDENTITY_MISSING_KEY = "unassignedUserTasks___";

    protected abstract ConfigurationService getConfigurationService();

    protected abstract DefinitionService getDefinitionService();

    protected abstract ProcessGroupByIdentityInterpreterHelper getHelper();

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        TermsAggregation termsAggregation = new TermsAggregation.Builder().size(this.getConfigurationService().getOpenSearchConfiguration().getAggregationBucketLimit()).field("flowNodeInstances." + this.getIdentityField()).order(Map.of("_key", org.opensearch.client.opensearch._types.SortOrder.Asc), new Map[0]).missing(FieldValue.of((String)GROUP_BY_IDENTITY_MISSING_KEY)).build();
        Aggregation groupByIdentityTermsAggregation = new Aggregation.Builder().terms(termsAggregation).aggregations(this.getDistributedByInterpreter().createAggregations(context, query)).build();
        Aggregation filteredUserTasksAggregation = new Aggregation.Builder().filter(ModelElementFilterQueryUtilOS.createInclusiveFlowNodeIdFilterQuery(context.getReportData(), this.getHelper().getUserTaskIds(context.getReportData()), context.getFilterContext(), this.getDefinitionService())).aggregations(GROUP_BY_IDENTITY_TERMS_AGGREGATION, groupByIdentityTermsAggregation).build();
        Aggregation userTasksAggregation = new Aggregation.Builder().filter(ModelElementFilterQueryUtilOS.createUserTaskFlowNodeTypeFilter().build().toQuery()).aggregations(FILTERED_USER_TASKS_AGGREGATION, filteredUserTasksAggregation).build();
        Aggregation flowNodesAggregation = new Aggregation.Builder().nested(n -> n.path(FLOW_NODES_AGGREGATION)).aggregations(USER_TASKS_AGGREGATION, userTasksAggregation).build();
        return Map.of(FLOW_NODES_AGGREGATION, flowNodesAggregation);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map aggregations = response.aggregations();
        NestedAggregate flowNodes = ((Aggregate)aggregations.get(FLOW_NODES_AGGREGATION)).nested();
        FilterAggregate userTasks = ((Aggregate)flowNodes.aggregations().get(USER_TASKS_AGGREGATION)).filter();
        FilterAggregate filteredUserTasks = ((Aggregate)userTasks.aggregations().get(FILTERED_USER_TASKS_AGGREGATION)).filter();
        List<CompositeCommandResult.GroupByResult> groupedData = this.getByIdentityAggregationResults(response, filteredUserTasks, context);
        compositeCommandResult.setGroups(groupedData);
        compositeCommandResult.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("label", SortOrder.ASC)));
    }

    protected abstract String getIdentityField();

    protected abstract IdentityType getIdentityType();

    private List<CompositeCommandResult.GroupByResult> getByIdentityAggregationResults(SearchResponse<RawResult> response, FilterAggregate filteredUserTasks, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        StringTermsAggregate byIdentityAggregation = ((Aggregate)filteredUserTasks.aggregations().get(GROUP_BY_IDENTITY_TERMS_AGGREGATION)).sterms();
        ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (StringTermsBucket identityBucket : byIdentityAggregation.buckets().array()) {
            boolean resultIsEmpty;
            String key = identityBucket.key();
            List<CompositeCommandResult.DistributedByResult> distributedByResults = this.getDistributedByInterpreter().retrieveResult(response, identityBucket.aggregations(), context);
            if (GROUP_BY_IDENTITY_MISSING_KEY.equals(key)) {
                distributedByResults.forEach(result -> result.getViewResult().getViewMeasures().forEach(measure -> Optional.ofNullable(measure.getAggregationType()).map(AggregationDto::getType).ifPresent(aggregationType -> {
                    if (AggregationType.SUM.equals(aggregationType) && measure.getValue() != null && measure.getValue() == 0.0) {
                        measure.setValue(null);
                    }
                })));
            }
            boolean bl = resultIsEmpty = distributedByResults.isEmpty() || distributedByResults.stream().map(CompositeCommandResult.DistributedByResult::getViewResult).map(CompositeCommandResult.ViewResult::getViewMeasures).flatMap(Collection::stream).allMatch(viewMeasure -> viewMeasure.getValue() == null || viewMeasure.getValue() == 0.0);
            if (resultIsEmpty) continue;
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(key, this.getHelper().resolveIdentityName(key, this::getIdentityType), distributedByResults));
        }
        return groupedData;
    }
}

