/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.report.filter.util.IncidentFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode.AbstractGroupByFlowNodeInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.groupby.flownode.GroupByIncidentFlowNodeInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class GroupByIncidentFlowNodeInterpreterOS
extends AbstractGroupByFlowNodeInterpreterOS {
    private static final String NESTED_INCIDENT_AGGREGATION = "nestedIncidentAggregation";
    private static final String GROUPED_BY_FLOW_NODE_ID_AGGREGATION = "groupedByFlowNodeIdAggregation";
    private static final String FILTERED_INCIDENT_AGGREGATION = "filteredIncidentAggregation";
    final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    final ProcessViewInterpreterFacadeOS viewInterpreter;
    private final ConfigurationService configurationService;
    private final GroupByIncidentFlowNodeInterpreterHelper helper;
    private final DefinitionService definitionService;

    public GroupByIncidentFlowNodeInterpreterOS(ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter, ConfigurationService configurationService, GroupByIncidentFlowNodeInterpreterHelper helper, DefinitionService definitionService) {
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
        this.configurationService = configurationService;
        this.helper = helper;
        this.definitionService = definitionService;
    }

    @Override
    protected DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_INCIDENT_FLOW_NODE);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        int size = this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit();
        Aggregation groupedByFlowNodeIdAggregation = new Aggregation.Builder().terms(AggregationDSL.termAggregation((String)"incidents.activityId", (int)size)).aggregations(this.getDistributedByInterpreter().createAggregations(context, query)).build();
        Aggregation filteredIncidentAggregation = new Aggregation.Builder().filter(IncidentFilterQueryUtilOS.createIncidentAggregationFilterQuery(context.getReportData(), this.definitionService)).aggregations(GROUPED_BY_FLOW_NODE_ID_AGGREGATION, groupedByFlowNodeIdAggregation).build();
        Aggregation aggregation = new Aggregation.Builder().nested(n -> n.path("incidents")).aggregations(FILTERED_INCIDENT_AGGREGATION, filteredIncidentAggregation).build();
        return Map.of(NESTED_INCIDENT_AGGREGATION, aggregation);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        NestedAggregate nestedAgg = ((Aggregate)response.aggregations().get(NESTED_INCIDENT_AGGREGATION)).nested();
        FilterAggregate filterAgg = ((Aggregate)nestedAgg.aggregations().get(FILTERED_INCIDENT_AGGREGATION)).filter();
        StringTermsAggregate groupedByFlowNodeId = ((Aggregate)filterAgg.aggregations().get(GROUPED_BY_FLOW_NODE_ID_AGGREGATION)).sterms();
        Map<String, String> flowNodeNames = this.helper.getFlowNodeNames(context.getReportData());
        ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (StringTermsBucket flowNodeBucket : groupedByFlowNodeId.buckets().array()) {
            String flowNodeKey = flowNodeBucket.key();
            if (!flowNodeNames.containsKey(flowNodeKey)) continue;
            List<CompositeCommandResult.DistributedByResult> singleResult = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)flowNodeBucket.aggregations(), context);
            String label = flowNodeNames.get(flowNodeKey);
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(flowNodeKey, label, singleResult));
            flowNodeNames.remove(flowNodeKey);
        }
        GroupByIncidentFlowNodeInterpreterHelper.addMissingGroupByIncidentKeys(flowNodeNames, groupedData, context, this.distributedByInterpreter.createEmptyResult(context));
        compositeCommandResult.setGroups(groupedData);
    }

    protected ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    protected ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

