/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby;

import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.context.VariableAggregationContextOS;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.AbstractGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.service.VariableAggregationServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.VariableAggregationContext;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.ReverseNestedAggregate;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractGroupByVariableInterpreterOS<DATA extends SingleReportDataDto, PLAN extends ExecutionPlan>
extends AbstractGroupByInterpreterOS<DATA, PLAN> {
    public static final String FILTERED_FLOW_NODE_AGGREGATION = "filteredFlowNodeAggregation";

    protected abstract VariableAggregationServiceOS getVariableAggregationService();

    protected abstract DefinitionService getDefinitionService();

    protected abstract String getVariableName(ExecutionContext<DATA, PLAN> var1);

    protected abstract VariableType getVariableType(ExecutionContext<DATA, PLAN> var1);

    protected abstract String getNestedVariableNameFieldLabel();

    protected abstract String getNestedVariableTypeField();

    protected abstract String getNestedVariableValueFieldLabel(VariableType var1);

    protected abstract String getVariablePath();

    protected abstract Query getVariableUndefinedOrNullQuery(ExecutionContext<DATA, PLAN> var1);

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<DATA, PLAN> context, Query baseQuery) {
        if (this.isGroupedByNumberVariable(this.getVariableType(context)) || VariableType.DATE.equals((Object)this.getVariableType(context))) {
            return Optional.of(this.getVariableAggregationService().getVariableMinMaxStats(this.getVariableType(context), this.getVariableName(context), this.getVariablePath(), this.getNestedVariableNameFieldLabel(), this.getNestedVariableValueFieldLabel(this.getVariableType(context)), this.getIndexNames(context), baseQuery));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<DATA, PLAN> context) {
        Aggregation reverseNestedAggregation = new Aggregation.Builder().reverseNested(b -> b).aggregations(this.createDistributedBySubAggregations(context, query)).build();
        VariableAggregationContext varAggContext = ((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContext.VariableAggregationContextBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)VariableAggregationContextOS.builder().variableName(this.getVariableName(context))).variableType(this.getVariableType(context))).variablePath(this.getVariablePath())).nestedVariableNameField(this.getNestedVariableNameFieldLabel())).nestedVariableValueFieldLabel(this.getNestedVariableValueFieldLabel(this.getVariableType(context)))).indexNames(this.getIndexNames(context))).timezone(context.getTimezone())).customBucketDto(context.getReportData().getConfiguration().getCustomBucket())).dateUnit(this.getGroupByDateUnit(context))).baseQueryForMinMaxStats(query)).subAggregations(Map.of("instCount", reverseNestedAggregation))).combinedRangeMinMaxStats(context.getCombinedRangeMinMaxStats().orElse(null))).filterContext(context.getFilterContext())).build();
        Optional<Pair<String, Aggregation>> variableSubAggregation = this.getVariableAggregationService().createVariableSubAggregation((VariableAggregationContextOS)varAggContext);
        Optional<Query> variableFilterQuery = this.getVariableAggregationService().createVariableFilterQuery((VariableAggregationContextOS)varAggContext);
        if (variableSubAggregation.isEmpty()) {
            return Map.of();
        }
        Aggregation emptyReverseNestedAggregation = new Aggregation.Builder().reverseNested(b -> b).build();
        Aggregation filteredVariablesAggregation = new Aggregation.Builder().filter(f -> f.bool(BoolQuery.of(q -> q.must(QueryDSL.term((String)this.getNestedVariableNameFieldLabel(), (String)this.getVariableName(context)), new Query[0]).must(QueryDSL.term((String)this.getNestedVariableTypeField(), (String)this.getVariableType(context).getId()), new Query[0]).must(QueryDSL.exists((String)this.getNestedVariableValueFieldLabel(VariableType.STRING)), new Query[0]).must(variableFilterQuery.orElse(QueryDSL.matchAll()), new Query[0])))).aggregations(Map.of((String)variableSubAggregation.get().getKey(), (Aggregation)variableSubAggregation.get().getValue(), "filteredInstCount", emptyReverseNestedAggregation)).build();
        Aggregation variableAggregation = new Aggregation.Builder().nested(b -> b.path(this.getVariablePath())).aggregations(Map.of("filteredVariables", filteredVariablesAggregation)).build();
        Pair<String, Aggregation> undefinedOrNullVariableAggregation = this.createUndefinedOrNullVariableAggregation(context, query);
        return Map.of("nestedVariables", variableAggregation, (String)undefinedOrNullVariableAggregation.getKey(), (Aggregation)undefinedOrNullVariableAggregation.getValue());
    }

    private boolean isFlownodeReport(PLAN plan) {
        if (plan instanceof ProcessExecutionPlan) {
            ProcessExecutionPlan processExecutionPlan = (ProcessExecutionPlan)plan;
            return Set.of(ProcessView.PROCESS_VIEW_FLOW_NODE_DURATION, ProcessView.PROCESS_VIEW_FLOW_NODE_FREQUENCY).contains((Object)processExecutionPlan.getView());
        }
        return false;
    }

    private Map<String, Aggregation> createDistributedBySubAggregations(ExecutionContext<DATA, PLAN> context, Query baseQuery) {
        if (this.isFlownodeReport(context.getPlan())) {
            Aggregation filterAggregation = new Aggregation.Builder().filter(ModelElementFilterQueryUtilOS.createModelElementAggregationFilter((ProcessReportDataDto)context.getReportData(), context.getFilterContext(), this.getDefinitionService()).build().toQuery()).aggregations(this.getDistributedByInterpreter().createAggregations(context, baseQuery)).build();
            Aggregation nestedFlownodeAggregation = new Aggregation.Builder().nested(b -> b.path("flowNodeInstances")).aggregations(Map.of(FILTERED_FLOW_NODE_AGGREGATION, filterAggregation)).build();
            return Map.of("nestedFlowNodes", nestedFlownodeAggregation);
        }
        return this.getDistributedByInterpreter().createAggregations(context, baseQuery);
    }

    private Pair<String, Aggregation> createUndefinedOrNullVariableAggregation(ExecutionContext<DATA, PLAN> context, Query baseQuery) {
        return Pair.of((Object)"missingVariables", (Object)new Aggregation.Builder().filter(this.getVariableUndefinedOrNullQuery(context)).aggregations(this.createDistributedBySubAggregations(context, baseQuery)).build());
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<DATA, PLAN> context) {
        if (response.aggregations() == null || response.aggregations().isEmpty()) {
            return;
        }
        NestedAggregate nested = ((Aggregate)response.aggregations().get("nestedVariables")).nested();
        FilterAggregate filteredVariables = ((Aggregate)nested.aggregations().get("filteredVariables")).filter();
        Aggregate filterLimitedAggregation = (Aggregate)filteredVariables.aggregations().get("filterLimitedAggregation");
        FilterAggregate filteredParentAgg = filterLimitedAggregation != null ? filterLimitedAggregation.filter() : filteredVariables;
        Aggregate variablesAggregation = (Aggregate)filteredParentAgg.aggregations().get("variables");
        Aggregate histogramAggregation = (Aggregate)filteredParentAgg.aggregations().get("numberVariableHistogram");
        Map<String, Map<String, Aggregate>> bucketMap = variablesAggregation != null ? this.getVariableAggregationService().resultBucketMap(variablesAggregation) : this.getVariableAggregationService().resultBucketMap(histogramAggregation);
        Map<String, Map<String, Aggregate>> bucketAggregations = this.getVariableAggregationService().retrieveResultBucketMap(filteredParentAgg, bucketMap, this.getVariableType(context), context.getTimezone());
        this.getDistributedByInterpreter().enrichContextWithAllExpectedDistributedByKeys(context, filteredParentAgg.aggregations());
        ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (Map.Entry<String, Map<String, Aggregate>> keyToAggregationEntry : bucketAggregations.entrySet()) {
            List<CompositeCommandResult.DistributedByResult> distribution = this.getDistributedByInterpreter().retrieveResult(response, this.getVariableAggregationService().retrieveSubAggregationFromBucketMapEntry(keyToAggregationEntry), context);
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(keyToAggregationEntry.getKey(), distribution));
        }
        this.addMissingVariableBuckets(groupedData, response, context);
        compositeCommandResult.setGroups(groupedData);
        if (VariableType.DATE.equals((Object)this.getVariableType(context))) {
            compositeCommandResult.setGroupBySorting(new ReportSortingDto("key", SortOrder.ASC));
        }
        compositeCommandResult.setGroupByKeyOfNumericType(this.getSortByKeyIsOfNumericType(context));
        compositeCommandResult.setDistributedByKeyOfNumericType(this.getDistributedByInterpreter().isKeyOfNumericType(context));
    }

    private void addMissingVariableBuckets(List<CompositeCommandResult.GroupByResult> groupedData, SearchResponse<RawResult> response, ExecutionContext<DATA, PLAN> context) {
        NestedAggregate nested = ((Aggregate)response.aggregations().get("nestedVariables")).nested();
        FilterAggregate filteredVariables = ((Aggregate)nested.aggregations().get("filteredVariables")).filter();
        ReverseNestedAggregate filteredInstAggr = ((Aggregate)filteredVariables.aggregations().get("filteredInstCount")).reverseNested();
        if (response.hits().total().value() > filteredInstAggr.docCount()) {
            List<CompositeCommandResult.DistributedByResult> missingVarsOperationResult = this.getDistributedByInterpreter().retrieveResult(response, this.retrieveAggregationsForMissingVariables(response), context);
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult("missing", missingVarsOperationResult));
        }
    }

    private Map<String, Aggregate> retrieveAggregationsForMissingVariables(SearchResponse<RawResult> response) {
        FilterAggregate aggregation = ((Aggregate)response.aggregations().get("missingVariables")).filter();
        Aggregate nestedFlowNodeAgg = (Aggregate)aggregation.aggregations().get("nestedFlowNodes");
        if (nestedFlowNodeAgg == null) {
            return aggregation.aggregations();
        }
        return ((Aggregate)nestedFlowNodeAgg.nested().aggregations().get(FILTERED_FLOW_NODE_AGGREGATION)).filter().aggregations();
    }

    private boolean getSortByKeyIsOfNumericType(ExecutionContext<DATA, PLAN> context) {
        return VariableType.getNumericTypes().contains(this.getVariableType(context));
    }

    private AggregateByDateUnit getGroupByDateUnit(ExecutionContext<DATA, PLAN> context) {
        return context.getReportData().getConfiguration().getGroupByDateVariableUnit();
    }

    private boolean isGroupedByNumberVariable(VariableType varType) {
        return VariableType.getNumericTypes().contains(varType);
    }
}

