/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.AssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CandidateGroupFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedOrCanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.DeletedIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.DurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutingFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeDurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.MultipleVariableFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NoIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NonCanceledInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NonSuspendedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.OpenIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ResolvedIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.SuspendedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.UserTaskFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.VariableFilterDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.report.filter.AssigneeQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CanceledFlowNodeQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CanceledFlowNodesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CanceledInstancesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CandidateGroupQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CompletedFlowNodesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CompletedInstancesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.CompletedOrCanceledFlowNodesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.DeletedIncidentQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.DurationQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.ExecutedFlowNodeQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.ExecutingFlowNodeQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.FlowNodeDurationQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.FlowNodeEndDateQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.FlowNodeStartDateQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.InstanceEndDateQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.InstanceStartDateQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.InstancesContainingUserTasksFilterOS;
import io.camunda.optimize.service.db.os.report.filter.NoIncidentQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.NonCanceledInstancesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.NonSuspendedInstancesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.OpenIncidentQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.ProcessMultiVariableQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.ProcessVariableQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.report.filter.ResolvedIncidentQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.RunningFlowNodesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.RunningInstancesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.SuspendedInstancesOnlyQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.util.IncidentFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.ListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessQueryFilterEnhancerOS
implements QueryFilterEnhancerOS<ProcessFilterDto<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessQueryFilterEnhancerOS.class);
    private final ConfigurationService configurationService;
    private final Environment environment;
    private final InstanceStartDateQueryFilterOS instanceStartDateQueryFilter;
    private final InstanceEndDateQueryFilterOS instanceEndDateQueryFilter;
    private final ProcessVariableQueryFilterOS variableQueryFilter;
    private final ProcessMultiVariableQueryFilterOS multiVariableQueryFilter;
    private final ExecutedFlowNodeQueryFilterOS executedFlowNodeQueryFilter;
    private final ExecutingFlowNodeQueryFilterOS executingFlowNodeQueryFilter;
    private final CanceledFlowNodeQueryFilterOS canceledFlowNodeQueryFilter;
    private final DurationQueryFilterOS durationQueryFilter;
    private final RunningInstancesOnlyQueryFilterOS runningInstancesOnlyQueryFilter;
    private final CompletedInstancesOnlyQueryFilterOS completedInstancesOnlyQueryFilter;
    private final CanceledInstancesOnlyQueryFilterOS canceledInstancesOnlyQueryFilter;
    private final NonCanceledInstancesOnlyQueryFilterOS nonCanceledInstancesOnlyQueryFilter;
    private final SuspendedInstancesOnlyQueryFilterOS suspendedInstancesOnlyQueryFilter;
    private final NonSuspendedInstancesOnlyQueryFilterOS nonSuspendedInstancesOnlyQueryFilter;
    private final FlowNodeDurationQueryFilterOS flowNodeDurationQueryFilter;
    private final AssigneeQueryFilterOS assigneeQueryFilter;
    private final CandidateGroupQueryFilterOS candidateGroupQueryFilter;
    private final OpenIncidentQueryFilterOS openIncidentQueryFilter;
    private final DeletedIncidentQueryFilterOS deletedIncidentQueryFilter;
    private final ResolvedIncidentQueryFilterOS resolvedIncidentQueryFilter;
    private final NoIncidentQueryFilterOS noIncidentQueryFilter;
    private final RunningFlowNodesOnlyQueryFilterOS runningFlowNodesOnlyQueryFilter;
    private final CompletedFlowNodesOnlyQueryFilterOS completedFlowNodesOnlyQueryFilter;
    private final CanceledFlowNodesOnlyQueryFilterOS canceledFlowNodesOnlyQueryFilter;
    private final CompletedOrCanceledFlowNodesOnlyQueryFilterOS completedOrCanceledFlowNodesOnlyQueryFilter;
    private final InstancesContainingUserTasksFilterOS instancesContainingUserTasksFilter;
    private final FlowNodeStartDateQueryFilterOS flowNodeStartDateQueryFilter;
    private final FlowNodeEndDateQueryFilterOS flowNodeEndDateQueryFilter;

    public ProcessQueryFilterEnhancerOS(ConfigurationService configurationService, Environment environment, InstanceStartDateQueryFilterOS instanceStartDateQueryFilter, InstanceEndDateQueryFilterOS instanceEndDateQueryFilter, ProcessVariableQueryFilterOS variableQueryFilter, ProcessMultiVariableQueryFilterOS multiVariableQueryFilter, ExecutedFlowNodeQueryFilterOS executedFlowNodeQueryFilter, ExecutingFlowNodeQueryFilterOS executingFlowNodeQueryFilter, CanceledFlowNodeQueryFilterOS canceledFlowNodeQueryFilter, DurationQueryFilterOS durationQueryFilter, RunningInstancesOnlyQueryFilterOS runningInstancesOnlyQueryFilter, CompletedInstancesOnlyQueryFilterOS completedInstancesOnlyQueryFilter, CanceledInstancesOnlyQueryFilterOS canceledInstancesOnlyQueryFilter, NonCanceledInstancesOnlyQueryFilterOS nonCanceledInstancesOnlyQueryFilter, SuspendedInstancesOnlyQueryFilterOS suspendedInstancesOnlyQueryFilter, NonSuspendedInstancesOnlyQueryFilterOS nonSuspendedInstancesOnlyQueryFilter, FlowNodeDurationQueryFilterOS flowNodeDurationQueryFilter, AssigneeQueryFilterOS assigneeQueryFilter, CandidateGroupQueryFilterOS candidateGroupQueryFilter, OpenIncidentQueryFilterOS openIncidentQueryFilter, DeletedIncidentQueryFilterOS deletedIncidentQueryFilter, ResolvedIncidentQueryFilterOS resolvedIncidentQueryFilter, NoIncidentQueryFilterOS noIncidentQueryFilter, RunningFlowNodesOnlyQueryFilterOS runningFlowNodesOnlyQueryFilter, CompletedFlowNodesOnlyQueryFilterOS completedFlowNodesOnlyQueryFilter, CanceledFlowNodesOnlyQueryFilterOS canceledFlowNodesOnlyQueryFilter, CompletedOrCanceledFlowNodesOnlyQueryFilterOS completedOrCanceledFlowNodesOnlyQueryFilter, InstancesContainingUserTasksFilterOS instancesContainingUserTasksFilter, FlowNodeStartDateQueryFilterOS flowNodeStartDateQueryFilter, FlowNodeEndDateQueryFilterOS flowNodeEndDateQueryFilter) {
        this.configurationService = configurationService;
        this.environment = environment;
        this.instanceStartDateQueryFilter = instanceStartDateQueryFilter;
        this.instanceEndDateQueryFilter = instanceEndDateQueryFilter;
        this.variableQueryFilter = variableQueryFilter;
        this.multiVariableQueryFilter = multiVariableQueryFilter;
        this.executedFlowNodeQueryFilter = executedFlowNodeQueryFilter;
        this.executingFlowNodeQueryFilter = executingFlowNodeQueryFilter;
        this.canceledFlowNodeQueryFilter = canceledFlowNodeQueryFilter;
        this.durationQueryFilter = durationQueryFilter;
        this.runningInstancesOnlyQueryFilter = runningInstancesOnlyQueryFilter;
        this.completedInstancesOnlyQueryFilter = completedInstancesOnlyQueryFilter;
        this.canceledInstancesOnlyQueryFilter = canceledInstancesOnlyQueryFilter;
        this.nonCanceledInstancesOnlyQueryFilter = nonCanceledInstancesOnlyQueryFilter;
        this.suspendedInstancesOnlyQueryFilter = suspendedInstancesOnlyQueryFilter;
        this.nonSuspendedInstancesOnlyQueryFilter = nonSuspendedInstancesOnlyQueryFilter;
        this.flowNodeDurationQueryFilter = flowNodeDurationQueryFilter;
        this.assigneeQueryFilter = assigneeQueryFilter;
        this.candidateGroupQueryFilter = candidateGroupQueryFilter;
        this.openIncidentQueryFilter = openIncidentQueryFilter;
        this.deletedIncidentQueryFilter = deletedIncidentQueryFilter;
        this.resolvedIncidentQueryFilter = resolvedIncidentQueryFilter;
        this.noIncidentQueryFilter = noIncidentQueryFilter;
        this.runningFlowNodesOnlyQueryFilter = runningFlowNodesOnlyQueryFilter;
        this.completedFlowNodesOnlyQueryFilter = completedFlowNodesOnlyQueryFilter;
        this.canceledFlowNodesOnlyQueryFilter = canceledFlowNodesOnlyQueryFilter;
        this.completedOrCanceledFlowNodesOnlyQueryFilter = completedOrCanceledFlowNodesOnlyQueryFilter;
        this.instancesContainingUserTasksFilter = instancesContainingUserTasksFilter;
        this.flowNodeStartDateQueryFilter = flowNodeStartDateQueryFilter;
        this.flowNodeEndDateQueryFilter = flowNodeEndDateQueryFilter;
    }

    @Override
    public List<Query> filterQueries(List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        ArrayList<Query> queries = new ArrayList<Query>();
        if (!CollectionUtils.isEmpty(filters)) {
            queries.addAll(this.allQueries(filters, filterContext));
            if (this.isAssigneeFiltersEnabled()) {
                queries.addAll(this.assigneeQueryFilter.filterQueries(this.extractInstanceFilters(filters, AssigneeFilterDto.class), filterContext));
            }
        }
        queries.addAll(this.instanceFilterForViewLevelMatchingQueries(filters, filterContext));
        return queries;
    }

    private List<Query> allQueries(List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        return ListUtil.concat((List[])new List[]{this.instanceStartDateQueryFilter.filterQueries(this.extractInstanceFilters(filters, InstanceStartDateFilterDto.class), filterContext), this.instanceEndDateQueryFilter.filterQueries(this.extractInstanceFilters(filters, InstanceEndDateFilterDto.class), filterContext), this.variableQueryFilter.filterQueries(this.extractInstanceFilters(filters, VariableFilterDto.class), filterContext), this.multiVariableQueryFilter.filterQueries(this.extractInstanceFilters(filters, MultipleVariableFilterDto.class), filterContext), this.executedFlowNodeQueryFilter.filterQueries(this.extractInstanceFilters(filters, ExecutedFlowNodeFilterDto.class), filterContext), this.executingFlowNodeQueryFilter.filterQueries(this.extractInstanceFilters(filters, ExecutingFlowNodeFilterDto.class), filterContext), this.canceledFlowNodeQueryFilter.filterQueries(this.extractInstanceFilters(filters, CanceledFlowNodeFilterDto.class), filterContext), this.durationQueryFilter.filterQueries(this.extractInstanceFilters(filters, DurationFilterDto.class), filterContext), this.runningInstancesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, RunningInstancesOnlyFilterDto.class), filterContext), this.completedInstancesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, CompletedInstancesOnlyFilterDto.class), filterContext), this.canceledInstancesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, CanceledInstancesOnlyFilterDto.class), filterContext), this.nonCanceledInstancesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, NonCanceledInstancesOnlyFilterDto.class), filterContext), this.suspendedInstancesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, SuspendedInstancesOnlyFilterDto.class), filterContext), this.nonSuspendedInstancesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, NonSuspendedInstancesOnlyFilterDto.class), filterContext), this.flowNodeDurationQueryFilter.filterQueries(this.extractInstanceFilters(filters, FlowNodeDurationFilterDto.class), filterContext), this.candidateGroupQueryFilter.filterQueries(this.extractInstanceFilters(filters, CandidateGroupFilterDto.class), filterContext), this.openIncidentQueryFilter.filterQueries(this.extractInstanceFilters(filters, OpenIncidentFilterDto.class), filterContext), this.deletedIncidentQueryFilter.filterQueries(this.extractInstanceFilters(filters, DeletedIncidentFilterDto.class), filterContext), this.resolvedIncidentQueryFilter.filterQueries(this.extractInstanceFilters(filters, ResolvedIncidentFilterDto.class), filterContext), this.noIncidentQueryFilter.filterQueries(this.extractInstanceFilters(filters, NoIncidentFilterDto.class), filterContext), this.runningFlowNodesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, RunningFlowNodesOnlyFilterDto.class), filterContext), this.completedFlowNodesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, CompletedFlowNodesOnlyFilterDto.class), filterContext), this.canceledFlowNodesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, CanceledFlowNodesOnlyFilterDto.class), filterContext), this.completedOrCanceledFlowNodesOnlyQueryFilter.filterQueries(this.extractInstanceFilters(filters, CompletedOrCanceledFlowNodesOnlyFilterDto.class), filterContext), this.instancesContainingUserTasksFilter.filterQueries(this.extractInstanceFilters(filters, UserTaskFlowNodesOnlyFilterDto.class), filterContext), this.flowNodeStartDateQueryFilter.filterQueries(this.extractInstanceFilters(filters, FlowNodeStartDateFilterDto.class), filterContext), this.flowNodeEndDateQueryFilter.filterQueries(this.extractInstanceFilters(filters, FlowNodeEndDateFilterDto.class), filterContext)});
    }

    public <T extends FilterDataDto> List<T> extractInstanceFilters(List<ProcessFilterDto<?>> filter, Class<? extends ProcessFilterDto<T>> clazz) {
        return filter.stream().filter(clazz::isInstance).filter(f -> FilterApplicationLevel.INSTANCE.equals((Object)f.getFilterLevel())).map(dateFilter -> dateFilter.getData()).collect(Collectors.toList());
    }

    private List<Query> instanceFilterForViewLevelMatchingQueries(List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        return Stream.of(ModelElementFilterQueryUtilOS.instanceFilterForRelevantViewLevelFiltersQuery(filters, filterContext), IncidentFilterQueryUtilOS.instanceFilterForRelevantViewLevelFiltersQuery(filters)).flatMap(Optional::stream).toList();
    }

    private boolean isAssigneeFiltersEnabled() {
        return this.configurationService.getUiConfiguration().isUserTaskAssigneeAnalyticsEnabled();
    }

    public InstanceStartDateQueryFilterOS getInstanceStartDateQueryFilter() {
        return this.instanceStartDateQueryFilter;
    }

    public InstanceEndDateQueryFilterOS getInstanceEndDateQueryFilter() {
        return this.instanceEndDateQueryFilter;
    }
}

