/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.query.TerminatedUserSessionDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.reader.TerminatedUserSessionReader;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Collections;
import org.opensearch.client.opensearch.core.GetRequest;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class TerminatedUserSessionReaderOS
extends TerminatedUserSessionReader {
    private final OptimizeOpenSearchClient osClient;

    public TerminatedUserSessionReaderOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    protected boolean sessionIdExists(String sessionId) {
        GetRequest.Builder requestBuilder = new GetRequest.Builder().index("terminated-user-session").id(sessionId).sourceIncludes(Collections.emptyList());
        String errorMessage = String.format("Was not able to fetch user session for ID [%s]", sessionId);
        return this.osClient.get(requestBuilder, TerminatedUserSessionDto.class, errorMessage).found();
    }
}

