/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.DashboardReader;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DashboardReaderOS
implements DashboardReader {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardReaderOS.class);
    private final OptimizeOpenSearchClient osClient;

    public DashboardReaderOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public long getDashboardCount() {
        String errorMessage = "Was not able to retrieve dashboard count!";
        return this.osClient.count(new String[]{"dashboard"}, QueryDSL.term((String)"managementDashboard", (boolean)false), "Was not able to retrieve dashboard count!");
    }

    @Override
    public Optional<DashboardDefinitionRestDto> getDashboard(String dashboardId) {
        LOG.debug("Fetching dashboard with id [{}]", (Object)dashboardId);
        GetRequest.Builder getRequest = new GetRequest.Builder().index("dashboard").id(dashboardId);
        String errorMessage = String.format("Could not fetch dashboard with id [%s]", dashboardId);
        GetResponse getResponse = this.osClient.get(getRequest, DashboardDefinitionRestDto.class, errorMessage);
        if (!getResponse.found()) {
            return Optional.empty();
        }
        return Optional.ofNullable((DashboardDefinitionRestDto)getResponse.source());
    }

    @Override
    public List<DashboardDefinitionRestDto> getDashboards(Set<String> dashboardIds) {
        LOG.debug("Fetching dashboards with IDs {}", dashboardIds);
        String[] dashboardIdsAsArray = dashboardIds.toArray(new String[0]);
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index("dashboard", new String[0]).query(QueryDSL.ids((String[])dashboardIdsAsArray)).size(Integer.valueOf(1000));
        String errorMessage = String.format("Was not able to fetch dashboards for IDs [%s]", dashboardIds);
        SearchResponse searchResponse = this.osClient.search(requestBuilder, DashboardDefinitionRestDto.class, errorMessage);
        return OpensearchReaderUtil.extractResponseValues(searchResponse);
    }

    @Override
    public List<DashboardDefinitionRestDto> getDashboardsForCollection(String collectionId) {
        LOG.debug("Fetching dashboards using collection with id {}", (Object)collectionId);
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index("dashboard", new String[0]).query(QueryDSL.term((String)"collectionId", (String)collectionId)).size(Integer.valueOf(1000));
        String errorMessage = String.format("Was not able to fetch dashboards for collection with id [%s]", collectionId);
        SearchResponse searchResponse = this.osClient.search(requestBuilder, DashboardDefinitionRestDto.class, errorMessage);
        return OpensearchReaderUtil.extractResponseValues(searchResponse);
    }

    @Override
    public List<DashboardDefinitionRestDto> getDashboardsForReport(String reportId) {
        LOG.debug("Fetching dashboards using report with id {}", (Object)reportId);
        Query getCombinedReportsBySimpleReportIdQuery = new BoolQuery.Builder().filter(new NestedQuery.Builder().path("tiles").query(QueryDSL.term((String)"tiles.id", (String)reportId)).scoreMode(ChildScoreMode.None).build().toQuery(), new Query[0]).build().toQuery();
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index("dashboard", new String[0]).query(getCombinedReportsBySimpleReportIdQuery).size(Integer.valueOf(1000));
        String errorMessage = String.format("Was not able to fetch dashboards for report with id [%s]", reportId);
        SearchResponse searchResponse = this.osClient.search(requestBuilder, DashboardDefinitionRestDto.class, errorMessage);
        return OpensearchReaderUtil.extractResponseValues(searchResponse);
    }
}

