/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.query.collection.BaseCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.CollectionReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class CollectionReaderOS
implements CollectionReader {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public CollectionReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public Optional<CollectionDefinitionDto> getCollection(String collectionId) {
        LOG.debug("Fetching collection with id [{}]", (Object)collectionId);
        GetRequest.Builder getRequest = new GetRequest.Builder().index("collection").id(collectionId);
        String errorMessage = String.format("Could not fetch collection with id [%s]", collectionId);
        GetResponse getResponse = this.osClient.get(getRequest, CollectionDefinitionDto.class, errorMessage);
        if (getResponse.found()) {
            if (Objects.isNull(getResponse.source())) {
                String reason = "Could not deserialize collection information for collection " + collectionId;
                LOG.error("Was not able to retrieve collection with id [{}] from OpenSearch. Reason: {}", (Object)collectionId, (Object)reason);
                throw new OptimizeRuntimeException(reason);
            }
            return Optional.of((CollectionDefinitionDto)getResponse.source());
        }
        return Optional.empty();
    }

    @Override
    public List<CollectionDefinitionDto> getAllCollections() {
        OpenSearchDocumentOperations.AggregatedResult scrollResp;
        LOG.debug("Fetching all available collections");
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index("collection", new String[0]).query(QueryDSL.matchAll()).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().order(SortOrder.Asc).field(BaseCollectionDefinitionDto.Fields.name.name()).build()).build(), new SortOptions[0]).size(Integer.valueOf(1000)).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        try {
            scrollResp = this.osClient.retrieveAllScrollResults(searchRequest, CollectionDefinitionDto.class);
        }
        catch (IOException e) {
            String errorMessage = "Was not able to retrieve collections!";
            LOG.error("Was not able to retrieve collections!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve collections!", (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(scrollResp);
    }
}

