/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.persistence.BusinessKeyDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.BusinessKeyReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class BusinessKeyReaderOS
implements BusinessKeyReader {
    private static final Logger LOG = LoggerFactory.getLogger(BusinessKeyReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public BusinessKeyReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public List<BusinessKeyDto> getBusinessKeysForProcessInstanceIds(Set<String> processInstanceIds) {
        OpenSearchDocumentOperations.AggregatedResult searchResponse;
        LOG.debug("Fetching business keys for [{}] process instances", (Object)processInstanceIds.size());
        if (processInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        SearchRequest.Builder searchReqBuilder = new SearchRequest.Builder().index("business-key", new String[0]).size(Integer.valueOf(1000)).query(QueryDSL.ids((String[])processInstanceIds.toArray(new String[0]))).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        try {
            searchResponse = this.osClient.retrieveAllScrollResults(searchReqBuilder, BusinessKeyDto.class);
        }
        catch (IOException e) {
            String errorMessage = "Was not able to retrieve business keys!";
            LOG.error("Was not able to retrieve business keys!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve business keys!", (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(searchResponse);
    }
}

