/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.sharing.DashboardShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ReportShareRestDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.writer.SharingWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class SharingWriterES
implements SharingWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SharingWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public SharingWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public ReportShareRestDto saveReportShare(ReportShareRestDto createSharingDto) {
        LOG.debug("Writing new report share to Elasticsearch");
        String id = IdGenerator.getNextId();
        createSharingDto.setId(id);
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "report-share").id(id).document((Object)createSharingDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write report share to Elasticsearch. Maybe the connection to Elasticsearch got lost?";
                LOG.error("Could not write report share to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
                throw new OptimizeRuntimeException("Could not write report share to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
            }
        }
        catch (IOException e) {
            String errorMessage = "Could not create report share.";
            LOG.error("Could not create report share.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not create report share.", (Throwable)e);
        }
        LOG.debug("report share with id [{}] for resource [{}] has been created", (Object)id, (Object)createSharingDto.getReportId());
        return createSharingDto;
    }

    @Override
    public DashboardShareRestDto saveDashboardShare(DashboardShareRestDto createSharingDto) {
        LOG.debug("Writing new dashboard share to Elasticsearch");
        String id = IdGenerator.getNextId();
        createSharingDto.setId(id);
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "dashboard-share").id(id).document((Object)createSharingDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write dashboard share to Elasticsearch. Maybe the connection to Elasticsearch got lost?";
                LOG.error("Could not write dashboard share to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
                throw new OptimizeRuntimeException("Could not write dashboard share to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
            }
        }
        catch (IOException e) {
            String errorMessage = "Could not create dashboard share.";
            LOG.error("Could not create dashboard share.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not create dashboard share.", (Throwable)e);
        }
        LOG.debug("dashboard share with id [{}] for resource [{}] has been created", (Object)id, (Object)createSharingDto.getDashboardId());
        return createSharingDto;
    }

    @Override
    public void updateDashboardShare(DashboardShareRestDto updatedShare) {
        String id = updatedShare.getId();
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "dashboard-share").id(id).document((Object)updatedShare).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created) && !indexResponse.result().equals((Object)Result.Updated)) {
                String message = "Could not write dashboard share to Elasticsearch.";
                LOG.error("Could not write dashboard share to Elasticsearch.");
                throw new OptimizeRuntimeException("Could not write dashboard share to Elasticsearch.");
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update dashboard share with id [%s] for resource [%s].", id, updatedShare.getDashboardId());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        LOG.debug("dashboard share with id [{}] for resource [{}] has been updated", (Object)id, (Object)updatedShare.getDashboardId());
    }

    @Override
    public void deleteReportShare(String shareId) {
        DeleteResponse deleteResponse;
        LOG.debug("Deleting report share with id [{}]", (Object)shareId);
        try {
            deleteResponse = this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "report-share").id(shareId).refresh(Refresh.True)));
        }
        catch (IOException e) {
            String reason = String.format("Could not delete report share with id [%s].", shareId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete report share with id [%s]. Report share does not exist. Maybe it was already deleted by someone else?", shareId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteDashboardShare(String shareId) {
        DeleteResponse deleteResponse;
        LOG.debug("Deleting dashboard share with id [{}]", (Object)shareId);
        try {
            deleteResponse = this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "dashboard-share").id(shareId).refresh(Refresh.True)));
        }
        catch (IOException e) {
            String reason = String.format("Could not delete dashboard share with id [%s].", shareId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete dashboard share with id [%s]. Dashboard share does not exist. Maybe it was already deleted by someone else?", shareId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }
}

