/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateOperationBuilderES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.writer.DecisionDefinitionXmlWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionDefinitionXmlWriterES
implements DecisionDefinitionXmlWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionDefinitionXmlWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public DecisionDefinitionXmlWriterES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public void importDecisionDefinitionXmls(List<DecisionDefinitionOptimizeDto> decisionDefinitions) {
        String importItemName = "decision definition XML information";
        LOG.debug("Writing [{}] {} to ES.", (Object)decisionDefinitions.size(), (Object)"decision definition XML information");
        this.esClient.doImportBulkRequestWithList("decision definition XML information", decisionDefinitions, this::addImportDecisionDefinitionXmlRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached().booleanValue());
    }

    private void addImportDecisionDefinitionXmlRequest(BulkRequest.Builder bulkRequestBuilder, DecisionDefinitionOptimizeDto decisionDefinitionDto) {
        Script updateScript = ElasticsearchWriterUtil.createFieldUpdateScript(FIELDS_TO_UPDATE, decisionDefinitionDto, this.objectMapper);
        bulkRequestBuilder.operations(o -> o.update(OptimizeUpdateOperationBuilderES.of(u -> ((UpdateOperation.Builder)u.optimizeIndex(this.esClient, "decision-definition").id(decisionDefinitionDto.getId())).action(a -> a.script(updateScript).upsert((Object)decisionDefinitionDto)).retryOnConflict(Integer.valueOf(5)))));
    }
}

