/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.writer.DecisionDefinitionWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionDefinitionWriterES
implements DecisionDefinitionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionDefinitionWriterES.class);
    private static final Script MARK_AS_DELETED_SCRIPT = Script.of(s -> s.inline(i -> i.lang(ScriptLanguage.Painless).source("ctx._source.deleted = true")));
    private final ObjectMapper objectMapper;
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final TaskRepositoryES taskRepositoryES;

    public DecisionDefinitionWriterES(ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, ConfigurationService configurationService, TaskRepositoryES taskRepositoryES) {
        this.objectMapper = objectMapper;
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public void importDecisionDefinitions(List<DecisionDefinitionOptimizeDto> decisionDefinitionOptimizeDtos) {
        LOG.debug("Writing [{}] decision definitions to elasticsearch", (Object)decisionDefinitionOptimizeDtos.size());
        this.writeDecisionDefinitionInformation(decisionDefinitionOptimizeDtos);
    }

    @Override
    public void markDefinitionAsDeleted(String definitionId) {
        LOG.debug("Marking decision definition with ID {} as deleted", (Object)definitionId);
        try {
            this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"decision-definition"}).id(definitionId).script(MARK_AS_DELETED_SCRIPT).retryOnConflict(Integer.valueOf(5)).build(), Object.class);
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException(String.format("There was a problem when trying to mark decision definition with ID %s as deleted", definitionId), (Throwable)e);
        }
    }

    @Override
    public boolean markRedeployedDefinitionsAsDeleted(List<DecisionDefinitionOptimizeDto> importedDefinitions) {
        AtomicBoolean definitionsUpdated = new AtomicBoolean(false);
        Lists.partition(importedDefinitions, (int)1000).forEach(partition -> {
            BoolQuery.Builder definitionsToDeleteQueryBuilder = new BoolQuery.Builder();
            HashSet decisionDefIds = new HashSet();
            partition.forEach(definition -> {
                BoolQuery.Builder matchingDefinitionQueryBuilder = new BoolQuery.Builder().must(m -> m.term(t -> t.field("key").value(definition.getKey()))).must(m -> m.term(t -> t.field("version").value(definition.getVersion()))).mustNot(m -> m.term(t -> t.field("id").value(definition.getId())));
                decisionDefIds.add(definition.getId());
                if (definition.getTenantId() != null) {
                    matchingDefinitionQueryBuilder.must(m -> m.term(t -> t.field("tenantId").value(definition.getTenantId())));
                } else {
                    matchingDefinitionQueryBuilder.mustNot(m -> m.exists(t -> t.field("tenantId")));
                }
                definitionsToDeleteQueryBuilder.should(s -> s.bool(matchingDefinitionQueryBuilder.build()));
            });
            boolean deleted = this.taskRepositoryES.tryUpdateByQueryRequest(String.format("%d decision definitions", decisionDefIds.size()), MARK_AS_DELETED_SCRIPT, Query.of(q -> q.bool(definitionsToDeleteQueryBuilder.build())), "decision-definition");
            if (deleted && !definitionsUpdated.get()) {
                definitionsUpdated.set(true);
            }
        });
        if (definitionsUpdated.get()) {
            LOG.debug("Marked old decision definitions with new deployments as deleted");
        }
        return definitionsUpdated.get();
    }

    private void writeDecisionDefinitionInformation(List<DecisionDefinitionOptimizeDto> decisionDefinitionOptimizeDtos) {
        String importItemName = "decision definition information";
        LOG.debug("Writing [{}] {} to ES.", (Object)decisionDefinitionOptimizeDtos.size(), (Object)"decision definition information");
        this.esClient.doImportBulkRequestWithList("decision definition information", decisionDefinitionOptimizeDtos, this::addImportDecisionDefinitionRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached().booleanValue());
    }

    private void addImportDecisionDefinitionRequest(BulkRequest.Builder bulkRequestBuilder, DecisionDefinitionOptimizeDto decisionDefinitionDto) {
        Script updateScript = ElasticsearchWriterUtil.createFieldUpdateScript(FIELDS_TO_UPDATE, decisionDefinitionDto, this.objectMapper);
        bulkRequestBuilder.operations(o -> o.update(OptimizeUpdateOperationBuilderES.of(u -> ((UpdateOperation.Builder)u.optimizeIndex(this.esClient, "decision-definition").id(decisionDefinitionDto.getId())).action(a -> a.script(updateScript).upsert(this.objectMapper.convertValue((Object)decisionDefinitionDto, Map.class))).retryOnConflict(Integer.valueOf(5)))));
    }
}

