/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.writer.AlertWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class AlertWriterES
implements AlertWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AlertWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final TaskRepositoryES taskRepositoryES;

    public AlertWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, TaskRepositoryES taskRepositoryES) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public AlertDefinitionDto createAlert(AlertDefinitionDto alertDefinitionDto) {
        LOG.debug("Writing new alert to Elasticsearch");
        String id = IdGenerator.getNextId();
        alertDefinitionDto.setId(id);
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "alert").id(id).document((Object)alertDefinitionDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write alert to Elasticsearch. Maybe the connection to Elasticsearch got lost?";
                LOG.error("Could not write alert to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
                throw new OptimizeRuntimeException("Could not write alert to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
            }
        }
        catch (IOException e) {
            String errorMessage = "Could not create alert.";
            LOG.error("Could not create alert.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not create alert.", (Throwable)e);
        }
        LOG.debug("alert with [{}] saved to elasticsearch", (Object)id);
        return alertDefinitionDto;
    }

    @Override
    public void updateAlert(AlertDefinitionDto alertUpdate) {
        LOG.debug("Updating alert with id [{}] in Elasticsearch", (Object)alertUpdate.getId());
        try {
            UpdateResponse updateResponse = this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"alert"}).id(alertUpdate.getId()).doc((Object)alertUpdate).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)).build(), AlertDefinitionDto.class);
            if (!updateResponse.shards().failures().isEmpty()) {
                String errorMessage = String.format("Was not able to update alert with id [%s] and name [%s]. Error during the update in Elasticsearch.", alertUpdate.getId(), alertUpdate.getName());
                LOG.error(errorMessage);
                throw new OptimizeRuntimeException(errorMessage);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update alert with id [%s] and name [%s].", alertUpdate.getId(), alertUpdate.getName());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (e.response().status() == HttpResponseStatus.BAD_REQUEST.code()) {
                String errorMessage = String.format("Was not able to update alert with id [%s] and name [%s]. Alert does not exist!", alertUpdate.getId(), alertUpdate.getName());
                LOG.error(errorMessage, (Throwable)e);
                throw new NotFoundException(errorMessage, (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void deleteAlert(String alertId) {
        DeleteResponse deleteResponse;
        LOG.debug("Deleting alert with id [{}]", (Object)alertId);
        try {
            deleteResponse = this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "alert").id(alertId).refresh(Refresh.True)));
        }
        catch (IOException e) {
            String reason = String.format("Could not delete alert with id [%s]. Maybe Optimize is not connected to Elasticsearch?", alertId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete alert with id [%s]. Alert does not exist. Maybe it was already deleted by someone else?", alertId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteAlerts(List<String> alertIds) {
        LOG.debug("Deleting alerts with ids: {}", alertIds);
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.bool(b -> b.must(m -> m.terms(t -> t.field("id").terms(tt -> tt.value(alertIds.stream().map(FieldValue::of).toList())))))), "alerts with Ids" + String.valueOf(alertIds), true, "alert");
    }

    @Override
    public void deleteAlertsForReport(String reportId) {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.term(t -> t.field("reportId").value(reportId))), String.format("all alerts for report with ID [%s]", reportId), true, "alert");
    }

    @Override
    public void writeAlertTriggeredStatus(boolean alertStatus, String alertId) {
        LOG.debug("Writing alert status for alert with id [{}] to Elasticsearch", (Object)alertId);
        try {
            this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"alert"}).id(alertId).doc((Object)Json.createObjectBuilder().add("triggered", alertStatus).build()).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)).build(), JsonObject.class);
        }
        catch (Exception e) {
            LOG.error("Can't update status of alert [{}]", (Object)alertId, (Object)e);
        }
    }
}

