/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.process.duration;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.process_part.ProcessPartDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.es.report.aggregations.AggregationStrategyES;
import io.camunda.optimize.service.db.es.report.interpreter.util.ProcessPartQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.duration.ProcessViewInstanceDurationInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.aggregations.AggregationStrategy;
import io.camunda.optimize.service.db.report.interpreter.view.process.duration.ProcessViewDurationInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessViewInstanceDurationOnProcessPartInterpreterES
extends ProcessViewInstanceDurationInterpreterES {
    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_INSTANCE_DURATION_PROCESS_PART);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        ProcessPartDto processPart = ProcessViewDurationInterpreterHelper.getProcessPart(context);
        return ProcessPartQueryUtilES.createProcessPartAggregation(processPart.getStart(), processPart.getEnd(), this.getAggregationStrategies(context.getReportData()).stream().map(AggregationStrategy::getAggregationType).collect(Collectors.toList()));
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List aggregationStrategies = this.getAggregationStrategies(context.getReportData());
        Function<AggregationStrategyES, Double> measureExtractor = aggregationStrategy -> ProcessPartQueryUtilES.getProcessPartAggregationResult(aggs, aggregationStrategy.getAggregationType());
        return ProcessViewDurationInterpreterHelper.retrieveResult(aggregationStrategies, measureExtractor);
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, BoolQuery.Builder baseQueryBuilder, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        super.adjustSearchRequest(searchRequestBuilder, baseQueryBuilder, context);
        ProcessPartDto processPart = ProcessViewDurationInterpreterHelper.getProcessPart(context);
        ProcessPartQueryUtilES.addProcessPartQuery(baseQueryBuilder, processPart.getStart(), processPart.getEnd());
    }
}

