/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.decision;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.es.report.interpreter.util.SortUtilsES;
import io.camunda.optimize.service.db.es.report.interpreter.view.decision.DecisionViewInterpreterES;
import io.camunda.optimize.service.db.reader.DecisionVariableReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.view.decision.AbstractDecisionViewRawDataInterpreter;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionViewRawDataInterpreterES
extends AbstractDecisionViewRawDataInterpreter
implements DecisionViewInterpreterES {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionViewRawDataInterpreterES.class);
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;
    private final OptimizeElasticsearchClient esClient;
    private final DecisionVariableReader decisionVariableReader;

    public DecisionViewRawDataInterpreterES(ConfigurationService configurationService, ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, DecisionVariableReader decisionVariableReader) {
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        this.esClient = esClient;
        this.decisionVariableReader = decisionVariableReader;
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, BoolQuery.Builder baseQueryBuilder, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        searchRequestBuilder.source(s -> s.fetch(Boolean.valueOf(true)));
        context.getPagination().ifPresent(pag -> {
            if (context.isCsvExport()) {
                searchRequestBuilder.size(Integer.valueOf(pag.getLimit() > 10000 ? 10000 : pag.getLimit()));
                searchRequestBuilder.scroll(s -> s.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"));
            } else {
                if (pag.getLimit() > 10000) {
                    pag.setLimit(Integer.valueOf(10000));
                }
                searchRequestBuilder.size(pag.getLimit()).from(pag.getOffset());
            }
        });
        this.addSortingToQuery(context.getReportData(), searchRequestBuilder);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return Map.of();
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        List<DecisionInstanceDto> rawDataDecisionInstanceDtos = context.isCsvExport() ? ElasticsearchReaderUtil.retrieveScrollResultsTillLimit(response, DecisionInstanceDto.class, this.objectMapper, this.esClient, this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds(), context.getPagination().orElse(new PaginationDto()).getLimit(), true) : ElasticsearchReaderUtil.mapHits(response.hits(), DecisionInstanceDto.class, this.objectMapper, true);
        List<RawDataDecisionInstanceDto> rawData = this.rawDataSingleReportResultDtoMapper.mapFrom(rawDataDecisionInstanceDtos, this.getInputVariableEntries((SingleReportDataDto)context.getReportData()), this.getOutputVars((SingleReportDataDto)context.getReportData()));
        this.addNewVariablesAndDtoFieldsToTableColumnConfig(context, rawData);
        return CompositeCommandResult.ViewResult.builder().rawData(rawData).build();
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return CompositeCommandResult.ViewResult.builder().rawData(new ArrayList()).build();
    }

    private void addSortingToQuery(DecisionReportDataDto decisionReportData, SearchRequest.Builder searchRequestBuilder) {
        Optional customSorting = decisionReportData.getConfiguration().getSorting();
        String sortByField = customSorting.flatMap(ReportSortingDto::getBy).orElse("evaluationDateTime");
        SortOrder sortOrder = customSorting.flatMap(ReportSortingDto::getOrder).map(order -> SortOrder.valueOf((String)order.name())).orElse(SortOrder.DESC);
        if (sortByField.startsWith("inputVariable:")) {
            this.addSortByInputVariable(searchRequestBuilder, sortByField, sortOrder);
        } else if (sortByField.startsWith("outputVariable:")) {
            this.addSortByOutputVariable(searchRequestBuilder, sortByField, sortOrder);
        } else {
            searchRequestBuilder.sort(s -> s.field(f -> f.field(sortByField).order(SortUtilsES.getSortOrder(sortOrder)).unmappedType(FieldType.Short)));
        }
    }

    private void addSortByInputVariable(SearchRequest.Builder searchRequestBuilder, String sortByField, SortOrder sortOrder) {
        DecisionVariableHelper.getVariableMultivalueFields().forEach(type -> searchRequestBuilder.sort(this.createSortByVariable(sortByField, sortOrder, "inputVariable:", "inputs", (VariableType)type), new SortOptions[0]));
        searchRequestBuilder.sort(this.createSortByVariable(sortByField, sortOrder, "inputVariable:", "inputs", VariableType.STRING), new SortOptions[0]);
    }

    private void addSortByOutputVariable(SearchRequest.Builder searchRequestBuilder, String sortByField, SortOrder sortOrder) {
        DecisionVariableHelper.getVariableMultivalueFields().forEach(type -> searchRequestBuilder.sort(this.createSortByVariable(sortByField, sortOrder, "outputVariable:", "outputs", (VariableType)type), new SortOptions[0]));
        searchRequestBuilder.sort(this.createSortByVariable(sortByField, sortOrder, "outputVariable:", "outputs", VariableType.STRING), new SortOptions[0]);
    }

    private SortOptions createSortByVariable(String sortByField, SortOrder sortOrder, String prefix, String variablePath, VariableType type) {
        String inputVariableId = sortByField.substring(prefix.length());
        String variableValuePath = DecisionVariableHelper.getVariableValueFieldForType(variablePath, type);
        String variableIdPath = DecisionVariableHelper.getVariableClauseIdField(variablePath);
        return SortOptions.of(s -> s.field(f -> f.field(variableValuePath).nested(n -> n.path(variablePath).filter(ff -> ff.term(t -> t.field(variableIdPath).value(inputVariableId)))).order(SortUtilsES.getSortOrder(sortOrder))));
    }

    @Override
    public DecisionVariableReader getDecisionVariableReader() {
        return this.decisionVariableReader;
    }
}

