/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.plan.process;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.service.db.es.builders.OptimizeBoolQueryBuilderES;
import io.camunda.optimize.service.db.es.filter.ProcessQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.GroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.ProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.plan.AbstractExecutionPlanInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.plan.process.ProcessExecutionPlanInterpreterES;
import io.camunda.optimize.service.db.es.schema.index.ProcessInstanceIndexES;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.util.DefinitionQueryUtilES;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractProcessExecutionPlanInterpreterES
extends AbstractExecutionPlanInterpreterES<ProcessReportDataDto, ProcessExecutionPlan>
implements ProcessExecutionPlanInterpreterES {
    private static final List<Class<? extends ProcessFilterDto<?>>> FILTERS_AFFECTING_BASELINE = List.of(InstanceStartDateFilterDto.class, InstanceEndDateFilterDto.class, FlowNodeStartDateFilterDto.class, FlowNodeEndDateFilterDto.class);

    protected abstract ProcessDefinitionReader getProcessDefinitionReader();

    protected abstract ProcessQueryFilterEnhancerES getQueryFilterEnhancer();

    @Override
    public Optional<MinMaxStatDto> getGroupByMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        GroupByInterpreterES groupByInterpreterES = this.getGroupByInterpreter();
        if (groupByInterpreterES instanceof ProcessGroupByInterpreterES) {
            ProcessGroupByInterpreterES processGroupByInterpreter = (ProcessGroupByInterpreterES)groupByInterpreterES;
            return processGroupByInterpreter.getMinMaxStats(context, Query.of(q -> q.bool(this.getBaseQueryBuilder(context).build())));
        }
        return Optional.empty();
    }

    @Override
    public BoolQuery.Builder getBaseQueryBuilder(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map dateFiltersByDefinition = context.getReportData().groupFiltersByDefinitionIdentifier();
        BoolQuery.Builder multiDefinitionFilterQueryBuilder = this.buildDefinitionBaseQueryForFilters(context, dateFiltersByDefinition);
        this.getQueryFilterEnhancer().addFilterToQuery(multiDefinitionFilterQueryBuilder, Stream.concat(dateFiltersByDefinition.getOrDefault("all", Collections.emptyList()).stream(), context.getReportData().getAdditionalFiltersForReportType().stream()).collect(Collectors.toList()), context.getFilterContext());
        return multiDefinitionFilterQueryBuilder;
    }

    @Override
    protected BoolQuery.Builder setupUnfilteredBaseQueryBuilder(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map<String, List<ProcessFilterDto<?>>> instanceLevelDateFiltersByDefinitionKey = context.getReportData().groupFiltersByDefinitionIdentifier().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().filter(filter -> filter.getFilterLevel() == FilterApplicationLevel.INSTANCE).filter(filter -> FILTERS_AFFECTING_BASELINE.contains(filter.getClass())).collect(Collectors.toList())));
        BoolQuery.Builder multiDefinitionFilterQuery = this.buildDefinitionBaseQueryForFilters(context, instanceLevelDateFiltersByDefinitionKey);
        this.getQueryFilterEnhancer().addFilterToQuery(multiDefinitionFilterQuery, instanceLevelDateFiltersByDefinitionKey.getOrDefault("all", Collections.emptyList()), context.getFilterContext());
        return multiDefinitionFilterQuery;
    }

    private BoolQuery.Builder buildDefinitionBaseQueryForFilters(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Map<String, List<ProcessFilterDto<?>>> filtersByDefinition) {
        if (context.getReportData().getDefinitions().isEmpty() && context.getReportData().isManagementReport()) {
            OptimizeBoolQueryBuilderES builder = new OptimizeBoolQueryBuilderES();
            builder.mustNot(m -> m.matchAll(i -> i));
            return builder;
        }
        BoolQuery.Builder multiDefinitionFilterQuery = new OptimizeBoolQueryBuilderES().minimumShouldMatch("1");
        context.getReportData().getDefinitions().forEach(definitionDto -> {
            BoolQuery.Builder definitionQueryBuilder = this.createDefinitionQuery((ReportDataDefinitionDto)definitionDto);
            this.getQueryFilterEnhancer().addFilterToQuery(definitionQueryBuilder, filtersByDefinition.getOrDefault(definitionDto.getIdentifier(), Collections.emptyList()), context.getFilterContext());
            multiDefinitionFilterQuery.should(s -> s.bool(definitionQueryBuilder.build()));
        });
        return multiDefinitionFilterQuery;
    }

    @Override
    protected String[] getIndexNames(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (context.getReportData().isManagementReport()) {
            this.getMultiIndexAlias();
        }
        return InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData());
    }

    @Override
    protected String[] getMultiIndexAlias() {
        return new String[]{"process-instance"};
    }

    private BoolQuery.Builder createDefinitionQuery(ReportDataDefinitionDto definitionDto) {
        return DefinitionQueryUtilES.createDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), new ProcessInstanceIndexES(definitionDto.getKey()), this.getProcessDefinitionReader()::getLatestVersionToKey);
    }
}

