/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.flownode;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.IncidentFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.flownode.AbstractGroupByFlowNodeInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.groupby.flownode.GroupByIncidentFlowNodeInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class GroupByIncidentFlowNodeInterpreterES
extends AbstractGroupByFlowNodeInterpreterES {
    private static final String NESTED_INCIDENT_AGGREGATION = "nestedIncidentAggregation";
    private static final String GROUPED_BY_FLOW_NODE_ID_AGGREGATION = "groupedByFlowNodeIdAggregation";
    private static final String FILTERED_INCIDENT_AGGREGATION = "filteredIncidentAggregation";
    final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ConfigurationService configurationService;
    private final GroupByIncidentFlowNodeInterpreterHelper helper;
    private final DefinitionService definitionService;

    public GroupByIncidentFlowNodeInterpreterES(ConfigurationService configurationService, GroupByIncidentFlowNodeInterpreterHelper helper, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter) {
        this.configurationService = configurationService;
        this.helper = helper;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_INCIDENT_FLOW_NODE);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path("incidents"));
        builder.aggregations(FILTERED_INCIDENT_AGGREGATION, Aggregation.of(a -> a.filter(f -> f.bool(IncidentFilterQueryUtilES.createIncidentAggregationFilter((ProcessReportDataDto)context.getReportData(), this.definitionService).build())).aggregations(GROUPED_BY_FLOW_NODE_ID_AGGREGATION, Aggregation.of(a1 -> {
            Aggregation.Builder.ContainerBuilder terms = a1.terms(t -> t.field("incidents.activityId").size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()));
            this.getDistributedByInterpreter().createAggregations(context, boolQuery).forEach((k, v) -> terms.aggregations(k, v.build()));
            return terms;
        }))));
        return Map.of(NESTED_INCIDENT_AGGREGATION, builder);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        NestedAggregate nestedAgg = ((Aggregate)response.aggregations().get(NESTED_INCIDENT_AGGREGATION)).nested();
        FilterAggregate filterAgg = ((Aggregate)nestedAgg.aggregations().get(FILTERED_INCIDENT_AGGREGATION)).filter();
        StringTermsAggregate groupedByFlowNodeId = ((Aggregate)filterAgg.aggregations().get(GROUPED_BY_FLOW_NODE_ID_AGGREGATION)).sterms();
        Map<String, String> flowNodeNames = this.helper.getFlowNodeNames(context.getReportData());
        ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (StringTermsBucket flowNodeBucket : groupedByFlowNodeId.buckets().array()) {
            String flowNodeKey = flowNodeBucket.key().stringValue();
            if (!flowNodeNames.containsKey(flowNodeKey)) continue;
            List<CompositeCommandResult.DistributedByResult> singleResult = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)flowNodeBucket.aggregations(), context);
            String label = flowNodeNames.get(flowNodeKey);
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(flowNodeKey, label, singleResult));
            flowNodeNames.remove(flowNodeKey);
        }
        GroupByIncidentFlowNodeInterpreterHelper.addMissingGroupByIncidentKeys(flowNodeNames, groupedData, context, this.distributedByInterpreter.createEmptyResult(context));
        compositeCommandResult.setGroups(groupedData);
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }
}

