/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.date;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.DistributedByType;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.DateGroupByValueDto;
import io.camunda.optimize.service.db.es.filter.ProcessQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.util.FilterLimitedAggregationUtilES;
import io.camunda.optimize.service.db.es.report.service.DateAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.groupby.ProcessGroupByProcessInstanceDateInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractProcessGroupByProcessInstanceDateInterpreterES
extends AbstractProcessGroupByInterpreterES {
    protected abstract ConfigurationService getConfigurationService();

    protected abstract DateAggregationServiceES getDateAggregationService();

    protected abstract MinMaxStatsServiceES getMinMaxStatsService();

    protected abstract ProcessQueryFilterEnhancerES getQueryFilterEnhancer();

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        DateGroupByValueDto groupByDate;
        if (context.getReportData().getGroupBy().getValue() instanceof DateGroupByValueDto && AggregateByDateUnit.AUTOMATIC.equals((Object)(groupByDate = (DateGroupByValueDto)context.getReportData().getGroupBy().getValue()).getUnit())) {
            return Optional.of(this.getMinMaxDateStats(context, baseQuery));
        }
        return Optional.empty();
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, BoolQuery.Builder baseQueryBuilder, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        super.adjustSearchRequest(searchRequestBuilder, baseQueryBuilder, context);
        baseQueryBuilder.must(m -> m.exists(e -> e.field(this.getDateField())));
    }

    public abstract String getDateField();

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        AggregateByDateUnit unit = this.getGroupByDateUnit(context.getReportData());
        return this.createAggregation(boolQuery, context, unit);
    }

    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, AggregateByDateUnit unit) {
        MinMaxStatDto stats = this.getMinMaxDateStats(context, Query.of(q -> q.bool(boolQuery)));
        DateAggregationContext dateAggContext = ((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)DateAggregationContextES.builder().aggregateByDateUnit(unit)).dateField(this.getDateField())).minMaxStats(stats)).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, boolQuery))).processGroupByType(context.getReportData().getGroupBy().getType())).processFilters(context.getReportData().getFilter())).processQueryFilterEnhancer(this.getQueryFilterEnhancer())).filterContext(context.getFilterContext())).build();
        return this.getDateAggregationService().createProcessInstanceDateAggregation((DateAggregationContextES)dateAggContext).map(agg -> this.addSiblingAggregationIfRequired(context, boolQuery, (Map<String, Aggregation.Builder.ContainerBuilder>)agg)).orElse(Map.of());
    }

    private MinMaxStatDto getMinMaxDateStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.getMinMaxStatsService().getMinMaxDateRange(context, baseQuery, this.getIndexNames(context), this.getDateField());
    }

    @Override
    public void addQueryResult(CompositeCommandResult result, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        ProcessGroupByProcessInstanceDateInterpreter.addQueryResult(this.processAggregations(response, response.aggregations(), context), this.getDistributedByInterpreter().isKeyOfNumericType(context), result, context);
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (aggregations == null) {
            return Collections.emptyList();
        }
        Optional<Map<String, Aggregate>> unwrappedLimitedAggregations = FilterLimitedAggregationUtilES.unwrapFilterLimitedAggregations(aggregations);
        if (unwrappedLimitedAggregations.isPresent()) {
            Map<String, Map<String, Aggregate>> keyToAggregationMap = this.getDateAggregationService().mapDateAggregationsToKeyAggregationMap(unwrappedLimitedAggregations.get(), context.getTimezone());
            this.getDistributedByInterpreter().enrichContextWithAllExpectedDistributedByKeys(context, unwrappedLimitedAggregations.get());
            return this.mapKeyToAggMapToGroupByResults(keyToAggregationMap, response, context);
        }
        return Collections.emptyList();
    }

    private List<CompositeCommandResult.GroupByResult> mapKeyToAggMapToGroupByResults(Map<String, Map<String, Aggregate>> keyToAggregationMap, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return keyToAggregationMap.entrySet().stream().map(stringBucketEntry -> CompositeCommandResult.GroupByResult.createGroupByResult((String)stringBucketEntry.getKey(), this.getDistributedByInterpreter().retrieveResult(response, (Map)stringBucketEntry.getValue(), context))).collect(Collectors.toList());
    }

    private AggregateByDateUnit getGroupByDateUnit(ProcessReportDataDto processReportData) {
        return ((DateGroupByValueDto)processReportData.getGroupBy().getValue()).getUnit();
    }

    private DistributedByType getDistributedByType(ProcessReportDataDto processReportDataDto) {
        return processReportDataDto.getDistributedBy().getType();
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> addSiblingAggregationIfRequired(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQuery, Map<String, Aggregation.Builder.ContainerBuilder> aggregationBuilders) {
        if (DistributedByType.VARIABLE.equals((Object)this.getDistributedByType(context.getReportData()))) {
            this.getDistributedByInterpreter().createAggregations(context, baseQuery).forEach((k, v) -> aggregationBuilders.forEach((k1, k2) -> k2.aggregations(k, v.build())));
        }
        return aggregationBuilders;
    }
}

