/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.VariableGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.VariableGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.AbstractGroupByVariableInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.ProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.VariableAggregationServiceES;
import io.camunda.optimize.service.db.es.util.ProcessVariableHelperES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByVariableInterpreterES
extends AbstractGroupByVariableInterpreterES<ProcessReportDataDto, ProcessExecutionPlan>
implements ProcessGroupByInterpreterES {
    private final VariableAggregationServiceES variableAggregationService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    private final ProcessViewInterpreterFacadeES viewInterpreter;

    public ProcessGroupByVariableInterpreterES(VariableAggregationServiceES variableAggregationService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter) {
        this.variableAggregationService = variableAggregationService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_VARIABLE);
    }

    private VariableGroupByValueDto getVariableGroupByDto(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return (VariableGroupByValueDto)((VariableGroupByDto)context.getReportData().getGroupBy()).getValue();
    }

    @Override
    protected String getVariableName(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.getVariableGroupByDto(context).getName();
    }

    @Override
    protected VariableType getVariableType(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.getVariableGroupByDto(context).getType();
    }

    @Override
    protected String getNestedVariableNameFieldLabel() {
        return ProcessVariableHelper.getNestedVariableNameField();
    }

    @Override
    protected String getNestedVariableTypeField() {
        return ProcessVariableHelper.getNestedVariableTypeField();
    }

    @Override
    protected String getNestedVariableValueFieldLabel(VariableType type) {
        return ProcessVariableHelper.getNestedVariableValueFieldForType(type);
    }

    @Override
    protected String getVariablePath() {
        return "variables";
    }

    @Override
    protected String[] getIndexNames(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData());
    }

    @Override
    protected BoolQuery.Builder getVariableUndefinedOrNullQuery(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        VariableGroupByValueDto variable = this.getVariableGroupByDto(context);
        return ProcessVariableHelperES.createFilterForUndefinedOrNullQueryBuilder(variable.getName(), variable.getType());
    }

    @Override
    public VariableAggregationServiceES getVariableAggregationService() {
        return this.variableAggregationService;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

