/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.decision;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.decision.DecisionDistributedByNoneInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.decision.AbstractDecisionGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.decision.DecisionViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionGroupByMatchedRuleInterpreterES
extends AbstractDecisionGroupByInterpreterES {
    private static final String MATCHED_RULES_AGGREGATION = "matchedRules";
    private final ConfigurationService configurationService;
    private final DecisionDistributedByNoneInterpreterES distributedByInterpreter;
    private final DecisionViewInterpreterFacadeES viewInterpreter;

    public DecisionGroupByMatchedRuleInterpreterES(ConfigurationService configurationService, DecisionDistributedByNoneInterpreterES distributedByInterpreter, DecisionViewInterpreterFacadeES viewInterpreter) {
        this.configurationService = configurationService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<DecisionGroupBy> getSupportedGroupBys() {
        return Set.of(DecisionGroupBy.DECISION_GROUP_BY_MATCHED_RULE);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().terms(t -> t.size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()).field(MATCHED_RULES_AGGREGATION));
        this.getDistributedByInterpreter().createAggregations(context, boolQuery).forEach((k, v) -> builder.aggregations(k, v.build()));
        return Map.of(MATCHED_RULES_AGGREGATION, builder);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        StringTermsAggregate matchedRuleTerms = ((Aggregate)response.aggregations().get(MATCHED_RULES_AGGREGATION)).sterms();
        ArrayList<CompositeCommandResult.GroupByResult> matchedRules = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (StringTermsBucket matchedRuleBucket : matchedRuleTerms.buckets().array()) {
            List<CompositeCommandResult.DistributedByResult> distributions = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)matchedRuleBucket.aggregations(), context);
            matchedRules.add(CompositeCommandResult.GroupByResult.createGroupByResult(matchedRuleBucket.key().stringValue(), distributions));
        }
        compositeCommandResult.setGroups(matchedRules);
    }

    public DecisionDistributedByNoneInterpreterES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public DecisionViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

