/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.reader.TerminatedUserSessionReader;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TerminatedUserSessionReaderES
extends TerminatedUserSessionReader {
    private final OptimizeElasticsearchClient esClient;

    public TerminatedUserSessionReaderES(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    @Override
    protected boolean sessionIdExists(String sessionId) throws IOException {
        return this.esClient.get(OptimizeGetRequestBuilderES.of(g -> g.optimizeIndex(this.esClient, "terminated-user-session").id(sessionId).source(s -> s.fetch(Boolean.valueOf(false)))), Object.class).found();
    }
}

