/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.sharing.DashboardShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ReportShareRestDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeCountRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.SharingReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class SharingReaderES
implements SharingReader {
    private static final Logger LOG = LoggerFactory.getLogger(SharingReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public SharingReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public Optional<ReportShareRestDto> getReportShare(String shareId) {
        GetResponse getResponse;
        Optional<ReportShareRestDto> result = Optional.empty();
        LOG.debug("Fetching report share with id [{}]", (Object)shareId);
        try {
            getResponse = this.esClient.get(OptimizeGetRequestBuilderES.of(g -> g.optimizeIndex(this.esClient, "report-share").id(shareId)), ReportShareRestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch report share with id [%s]", shareId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (getResponse.found()) {
            result = Optional.of((ReportShareRestDto)getResponse.source());
        }
        return result;
    }

    @Override
    public Optional<DashboardShareRestDto> findDashboardShare(String shareId) {
        GetResponse getResponse;
        Optional<DashboardShareRestDto> result = Optional.empty();
        LOG.debug("Fetching dashboard share with id [{}]", (Object)shareId);
        try {
            getResponse = this.esClient.get(OptimizeGetRequestBuilderES.of(g -> g.optimizeIndex(this.esClient, "dashboard-share").id(shareId)), DashboardShareRestDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch dashboard share with id [%s]", shareId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (getResponse.found()) {
            result = Optional.of((DashboardShareRestDto)getResponse.source());
        }
        return result;
    }

    @Override
    public Optional<ReportShareRestDto> findShareForReport(String reportId) {
        LOG.debug("Fetching share for resource [{}]", (Object)reportId);
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.must(m -> m.term(t -> t.field("reportId").value(reportId))));
        return this.findReportShareByQuery(builder);
    }

    @Override
    public Optional<DashboardShareRestDto> findShareForDashboard(String dashboardId) {
        LOG.debug("Fetching share for resource [{}]", (Object)dashboardId);
        SearchResponse<DashboardShareRestDto> searchResponse = this.performSearchShareForDashboardIdRequest(dashboardId, DashboardShareRestDto.class);
        return this.extractDashboardShareFromResponse(dashboardId, searchResponse);
    }

    @Override
    public Map<String, ReportShareRestDto> findShareForReports(List<String> reports) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.must(m -> m.terms(t -> t.field("reportId").terms(tt -> tt.value(reports.stream().map(FieldValue::of).toList())))));
        return this.findReportSharesByQuery(builder);
    }

    @Override
    public Map<String, DashboardShareRestDto> findShareForDashboards(List<String> dashboards) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> b.must(m -> m.terms(t -> t.field("dashboardId").terms(tt -> tt.value(dashboards.stream().map(FieldValue::of).toList())))));
        return this.findDashboardSharesByQuery(builder);
    }

    private Optional<ReportShareRestDto> findReportShareByQuery(Query.Builder query) {
        SearchResponse searchResponse;
        Optional<ReportShareRestDto> result = Optional.empty();
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"report-share"}).query(query.build()).size(Integer.valueOf(1)));
        try {
            searchResponse = this.esClient.search(searchRequest, ReportShareRestDto.class);
        }
        catch (IOException e) {
            String reason = "Was not able to fetch report share.";
            LOG.error("Was not able to fetch report share.", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to fetch report share.", (Throwable)e);
        }
        if (searchResponse.hits().total().value() != 0L) {
            result = Optional.of((ReportShareRestDto)((Hit)searchResponse.hits().hits().get(0)).source());
        }
        return result;
    }

    @Override
    public long getShareCount(String indexName) {
        try {
            return this.esClient.count(OptimizeCountRequestBuilderES.of(c -> c.optimizeIndex(this.esClient, indexName))).count();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(String.format("Was not able to retrieve count for type: %s", indexName), (Throwable)e);
        }
    }

    private Optional<DashboardShareRestDto> extractDashboardShareFromResponse(String dashboardId, SearchResponse<DashboardShareRestDto> searchResponse) {
        Optional<DashboardShareRestDto> result = Optional.empty();
        if (searchResponse.hits().total().value() != 0L) {
            result = Optional.of((DashboardShareRestDto)((Hit)searchResponse.hits().hits().get(0)).source());
        }
        return result;
    }

    private <T> SearchResponse<T> performSearchShareForDashboardIdRequest(String dashboardId, Class<T> clas) {
        SearchResponse searchResponse;
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"dashboard-share"}).query(m -> m.bool(b -> b.must(r -> r.term(t -> t.field("dashboardId").value(dashboardId))))).size(Integer.valueOf(1)));
        try {
            searchResponse = this.esClient.search(searchRequest, clas);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch share for dashboard with id [%s]", dashboardId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return searchResponse;
    }

    private Map<String, ReportShareRestDto> findReportSharesByQuery(Query.Builder query) {
        SearchResponse scrollResp;
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"report-share"}).query(query.build()).size(Integer.valueOf(1000)).scroll(s1 -> s1.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")));
        try {
            scrollResp = this.esClient.search(searchRequest, ReportShareRestDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve report shares!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve report shares!", (Throwable)e);
        }
        List<ReportShareRestDto> reportShareDtos = ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, ReportShareRestDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
        return reportShareDtos.stream().collect(Collectors.toMap(ReportShareRestDto::getReportId, Function.identity()));
    }

    private Map<String, DashboardShareRestDto> findDashboardSharesByQuery(Query.Builder query) {
        SearchResponse scrollResp;
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"dashboard-share"}).query(query.build()).size(Integer.valueOf(1000)).scroll(s1 -> s1.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")));
        try {
            scrollResp = this.esClient.search(searchRequest, DashboardShareRestDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve dashboard shares!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve dashboard shares!", (Throwable)e);
        }
        List<DashboardShareRestDto> dashboardShareDtos = ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, DashboardShareRestDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
        return dashboardShareDtos.stream().collect(Collectors.toMap(DashboardShareRestDto::getDashboardId, Function.identity()));
    }
}

