/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.dashboard.InstantDashboardDataDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.reader.InstantDashboardMetadataReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class InstantDashboardMetadataReaderES
implements InstantDashboardMetadataReader {
    private static final Logger LOG = LoggerFactory.getLogger(InstantDashboardMetadataReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public InstantDashboardMetadataReaderES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public Optional<String> getInstantDashboardIdFor(String processDefinitionKey, String template) throws OptimizeRuntimeException {
        GetResponse getResponse;
        LOG.debug("Fetching Instant preview dashboard ID for [{}] with template [{}] ", (Object)processDefinitionKey, (Object)template);
        InstantDashboardDataDto dashboardDataDto = new InstantDashboardDataDto();
        dashboardDataDto.setTemplateName(template);
        dashboardDataDto.setProcessDefinitionKey(processDefinitionKey);
        String instantDashboardKey = dashboardDataDto.getInstantDashboardId();
        GetRequest getRequest = OptimizeGetRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "instant-dashboard").id(instantDashboardKey));
        try {
            getResponse = this.esClient.get(getRequest, InstantDashboardDataDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch Instant preview dashboard with key [%s]", instantDashboardKey);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (getResponse.found()) {
            InstantDashboardDataDto dashboardData = (InstantDashboardDataDto)getResponse.source();
            return Optional.of(dashboardData.getDashboardId());
        }
        String reason = "Could not find dashboard data for key [" + instantDashboardKey + "] in Elasticsearch.";
        LOG.error(reason);
        return Optional.empty();
    }
}

