/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.ClearScrollResponse;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.PageResultDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticsearchReaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchReaderUtil.class);

    private ElasticsearchReaderUtil() {
    }

    public static <T> List<T> retrieveAllScrollResults(SearchResponse<T> initialScrollResponse, Class<T> itemClass, ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds) {
        return ElasticsearchReaderUtil.retrieveScrollResultsTillLimit(initialScrollResponse, itemClass, objectMapper, esClient, scrollingTimeoutInSeconds, (Integer)Integer.MAX_VALUE);
    }

    public static <T> List<T> retrieveAllScrollResults(SearchResponse<?> initialScrollResponse, Class<T> itemClass, Function<Hit<?>, T> mappingFunction, OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds) {
        return ElasticsearchReaderUtil.retrieveScrollResultsTillLimit(initialScrollResponse, itemClass, mappingFunction, esClient, scrollingTimeoutInSeconds, (Integer)Integer.MAX_VALUE);
    }

    public static <T> List<T> retrieveScrollResultsTillLimit(ResponseBody<?> initialScrollResponse, Class<T> itemClass, ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds, Integer limit) {
        return ElasticsearchReaderUtil.retrieveScrollResultsTillLimit(initialScrollResponse, itemClass, objectMapper, esClient, scrollingTimeoutInSeconds, limit, false);
    }

    public static <T> List<T> retrieveScrollResultsTillLimit(ResponseBody<?> initialScrollResponse, Class<T> itemClass, ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds, Integer limit, boolean agg) {
        return ElasticsearchReaderUtil.retrieveScrollResultsTillLimit(initialScrollResponse, itemClass, (Hit<?> h) -> {
            if (agg) {
                try {
                    return objectMapper.readValue(h.source().toString(), itemClass);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return objectMapper.convertValue(h.source(), itemClass);
        }, esClient, scrollingTimeoutInSeconds, limit);
    }

    public static <T> PageResultDto<T> retrieveNextScrollResultsPage(String scrollId, Class<T> itemClass, Function<Hit<?>, T> mappingFunction, OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds, Integer limit) {
        HitsMetadata currentHits;
        PageResultDto pageResult = new PageResultDto(limit);
        String currentScrollId = scrollId;
        do {
            if (pageResult.getEntities().size() < limit) {
                ScrollResponse<?> currentScrollResp = ElasticsearchReaderUtil.getScrollResponse(esClient, scrollingTimeoutInSeconds, currentScrollId);
                currentScrollId = currentScrollResp.scrollId();
                currentHits = currentScrollResp.hits();
                pageResult.getEntities().addAll(ElasticsearchReaderUtil.mapHits(currentHits, limit - pageResult.getEntities().size(), itemClass, mappingFunction));
                pageResult.setPagingState(currentScrollId);
                continue;
            }
            currentHits = null;
        } while (currentHits != null && !currentHits.hits().isEmpty());
        if (pageResult.getEntities().isEmpty() || pageResult.getEntities().size() < limit) {
            ElasticsearchReaderUtil.clearScroll(itemClass, esClient, currentScrollId);
            pageResult.setPagingState(null);
        }
        return pageResult;
    }

    private static ScrollResponse<?> getScrollResponse(OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds, String scrollId) {
        ScrollResponse currentScrollResp;
        ScrollRequest scrollRequest = ScrollRequest.of(b -> b.scrollId(scrollId).scroll(s -> s.time(scrollingTimeoutInSeconds + "s")));
        try {
            currentScrollResp = esClient.scroll(scrollRequest, Object.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not get scroll response through entries for scrollId [%s].", scrollId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return currentScrollResp;
    }

    public static <T> List<T> retrieveScrollResultsTillLimit(ResponseBody<?> initialScrollResponse, Class<T> itemClass, Function<Hit<?>, T> mappingFunction, OptimizeElasticsearchClient esClient, Integer scrollingTimeoutInSeconds, Integer limit) {
        ArrayList<T> results = new ArrayList<T>();
        ScrollResponse currentScrollResp = initialScrollResponse;
        HitsMetadata hits = currentScrollResp.hits();
        while (hits != null && !hits.hits().isEmpty()) {
            results.addAll(ElasticsearchReaderUtil.mapHits(hits, limit - results.size(), itemClass, mappingFunction));
            if (results.size() < limit) {
                try {
                    ScrollResponse finalCurrentScrollResp = currentScrollResp;
                    currentScrollResp = esClient.scroll(ScrollRequest.of(s -> s.scrollId(finalCurrentScrollResp.scrollId()).scroll(o -> o.time(scrollingTimeoutInSeconds + "s"))), itemClass);
                    hits = currentScrollResp.hits();
                    continue;
                }
                catch (IOException e) {
                    String reason = String.format("Could not scroll through entries for class [%s].", itemClass.getSimpleName());
                    LOG.error(reason, (Throwable)e);
                    throw new OptimizeRuntimeException(reason, (Throwable)e);
                }
            }
            hits = null;
        }
        ElasticsearchReaderUtil.clearScroll(itemClass, esClient, currentScrollResp.scrollId());
        return results;
    }

    private static <T> void clearScroll(Class<T> itemClass, OptimizeElasticsearchClient esClient, String scrollId) {
        ClearScrollResponse clearScrollResponse = esClient.clearScroll(ClearScrollRequest.of(b -> b.scrollId(scrollId, new String[0])));
        boolean succeeded = clearScrollResponse.succeeded();
        if (!succeeded) {
            String reason = String.format("Could not clear scroll for class [%s], since Elasticsearch was unable to perform the action!", itemClass.getSimpleName());
            LOG.error(reason);
        }
    }

    public static <T> List<T> mapHits(HitsMetadata<?> searchHits, Class<T> itemClass, ObjectMapper objectMapper) {
        return ElasticsearchReaderUtil.mapHits(searchHits, itemClass, objectMapper, false);
    }

    public static <T> List<T> mapHits(HitsMetadata<?> searchHits, Class<T> itemClass, ObjectMapper objectMapper, boolean agg) {
        return ElasticsearchReaderUtil.mapHits(searchHits, Integer.MAX_VALUE, itemClass, h -> {
            if (itemClass.isInstance(h.source())) {
                return itemClass.cast(h.source());
            }
            if (agg) {
                try {
                    return objectMapper.readValue(h.source().toString(), itemClass);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return objectMapper.convertValue(h.source(), itemClass);
        });
    }

    public static <T> List<T> mapHits(HitsMetadata<?> searchHits, Integer resultLimit, Class<T> itemClass, Function<Hit<?>, T> mappingFunction) {
        ArrayList<T> results = new ArrayList<T>();
        for (Hit hit : searchHits.hits()) {
            if (results.size() >= resultLimit) break;
            try {
                T mappedHit = mappingFunction.apply(hit);
                results.add(mappedHit);
            }
            catch (Exception e) {
                String reason = "While mapping search results to class {} it was not possible to deserialize a hit from Elasticsearch!";
                LOG.error("While mapping search results to class {} it was not possible to deserialize a hit from Elasticsearch!", (Object)itemClass.getSimpleName(), (Object)e);
                throw new OptimizeRuntimeException("While mapping search results to class {} it was not possible to deserialize a hit from Elasticsearch!");
            }
        }
        return results;
    }

    public static <T> boolean atLeastOneResponseExistsForMultiGet(MgetResponse<T> multiGetResponse) {
        return multiGetResponse.docs().stream().anyMatch(multiGetItemResponse -> multiGetItemResponse.result().found());
    }
}

