/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.persistence.BusinessKeyDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.BusinessKeyReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class BusinessKeyReaderES
implements BusinessKeyReader {
    private static final Logger LOG = LoggerFactory.getLogger(BusinessKeyReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;

    public BusinessKeyReaderES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, ConfigurationService configurationService) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
    }

    @Override
    public List<BusinessKeyDto> getBusinessKeysForProcessInstanceIds(Set<String> processInstanceIds) {
        SearchResponse searchResponse;
        LOG.debug("Fetching business keys for [{}] process instances", (Object)processInstanceIds.size());
        if (processInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"business-key"}).query(q -> q.ids(i -> i.values(processInstanceIds.stream().toList()))).size(Integer.valueOf(1000)).scroll(Time.of(t -> t.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"))));
        try {
            searchResponse = this.esClient.search(searchRequest, BusinessKeyDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve business keys!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve event business keys!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(searchResponse, BusinessKeyDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }
}

