/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter.util;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentStatus;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.OpenIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ResolvedIncidentFilterDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.filter.util.NestedDefinitionQueryBuilderES;
import io.camunda.optimize.service.db.report.filter.util.IncidentFilterQueryUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class IncidentFilterQueryUtilES
extends IncidentFilterQueryUtil {
    private static final NestedDefinitionQueryBuilderES NESTED_DEFINITION_QUERY_BUILDER = new NestedDefinitionQueryBuilderES("incidents", "definitionKey", "definitionVersion", "tenantId");
    private static final Map<Class<? extends ProcessFilterDto<?>>, Function<BoolQuery.Builder, BoolQuery.Builder>> INCIDENT_VIEW_FILTER_INSTANCE_QUERIES = ImmutableMap.of(OpenIncidentFilterDto.class, IncidentFilterQueryUtilES::createOpenIncidentTermQuery, ResolvedIncidentFilterDto.class, IncidentFilterQueryUtilES::createResolvedIncidentTermQuery);

    private IncidentFilterQueryUtilES() {
    }

    public static BoolQuery.Builder createIncidentAggregationFilter(ProcessReportDataDto reportData, DefinitionService definitionService) {
        BoolQuery.Builder filterBoolQuery = new BoolQuery.Builder().minimumShouldMatch("1");
        Map filtersByDefinition = reportData.groupFiltersByDefinitionIdentifier();
        reportData.getDefinitions().forEach(definitionDto -> {
            BoolQuery.Builder incidentDefinitionQuery = new BoolQuery.Builder();
            incidentDefinitionQuery.must(m -> NESTED_DEFINITION_QUERY_BUILDER.createNestedDocDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), definitionService));
            IncidentFilterQueryUtilES.addIncidentFilters(incidentDefinitionQuery, filtersByDefinition.getOrDefault(definitionDto.getIdentifier(), Collections.emptyList()));
            filterBoolQuery.should(s -> s.bool(incidentDefinitionQuery.build()));
        });
        IncidentFilterQueryUtilES.addIncidentFilters(filterBoolQuery, filtersByDefinition.getOrDefault("all", Collections.emptyList()));
        return filterBoolQuery;
    }

    private static void addIncidentFilters(BoolQuery.Builder filterBoolQuery, List<ProcessFilterDto<?>> filters) {
        IncidentFilterQueryUtilES.addOpenIncidentFilter(filterBoolQuery, filters);
        IncidentFilterQueryUtilES.addResolvedIncidentFilter(filterBoolQuery, filters);
        IncidentFilterQueryUtilES.addExecutedFlowNodeFilter(filterBoolQuery, filters);
    }

    public static Optional<NestedQuery.Builder> addInstanceFilterForRelevantViewLevelFilters(List<ProcessFilterDto<?>> filters) {
        List<ProcessFilterDto> viewLevelFiltersForInstanceMatch = filters.stream().filter(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).filter(filter -> INCIDENT_VIEW_FILTER_INSTANCE_QUERIES.containsKey(filter.getClass())).collect(Collectors.toList());
        if (!viewLevelFiltersForInstanceMatch.isEmpty()) {
            BoolQuery.Builder viewFilterInstanceQuery = new BoolQuery.Builder();
            viewLevelFiltersForInstanceMatch.forEach(filter -> INCIDENT_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply(viewFilterInstanceQuery));
            NestedQuery.Builder builder = new NestedQuery.Builder();
            builder.path("incidents").scoreMode(ChildScoreMode.None).query(q -> q.bool(viewFilterInstanceQuery.build()));
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    public static Query.Builder createResolvedIncidentTermQuery() {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> IncidentFilterQueryUtilES.createResolvedIncidentTermQuery(new BoolQuery.Builder()));
        return builder;
    }

    private static BoolQuery.Builder createResolvedIncidentTermQuery(BoolQuery.Builder boolQuery) {
        return boolQuery.must(m -> m.term(t -> t.field("incidents.incidentStatus").value(IncidentStatus.RESOLVED.getId())));
    }

    public static BoolQuery.Builder createOpenIncidentTermQuery() {
        return IncidentFilterQueryUtilES.createOpenIncidentTermQuery(new BoolQuery.Builder());
    }

    public static BoolQuery.Builder createDeletedIncidentTermQuery() {
        return IncidentFilterQueryUtilES.createDeletedIncidentTermQuery(new BoolQuery.Builder());
    }

    private static BoolQuery.Builder createDeletedIncidentTermQuery(BoolQuery.Builder boolQuery) {
        return new BoolQuery.Builder().must(m -> m.term(t -> t.field("incidents.incidentStatus").value(IncidentStatus.DELETED.getId())));
    }

    private static BoolQuery.Builder createOpenIncidentTermQuery(BoolQuery.Builder boolQuery) {
        return boolQuery.must(m -> m.term(t -> t.field("incidents.incidentStatus").value(IncidentStatus.OPEN.getId())));
    }

    private static void addOpenIncidentFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        if (IncidentFilterQueryUtilES.containsViewLevelFilterOfType(filters, OpenIncidentFilterDto.class)) {
            boolQuery.filter(f -> f.bool(IncidentFilterQueryUtilES.createOpenIncidentTermQuery().build()));
        }
    }

    private static void addResolvedIncidentFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        if (IncidentFilterQueryUtilES.containsViewLevelFilterOfType(filters, ResolvedIncidentFilterDto.class)) {
            boolQuery.filter(f -> IncidentFilterQueryUtilES.createResolvedIncidentTermQuery());
        }
    }

    public static void addExecutedFlowNodeFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        IncidentFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, ExecutedFlowNodeFilterDto.class).map(ProcessFilterDto::getData).forEach(executedFlowNodeFilterData -> boolQuery.filter(f -> f.bool(ModelElementFilterQueryUtilES.createExecutedFlowNodeFilterQuery(executedFlowNodeFilterData, IncidentFilterQueryUtilES.nestedFieldReference("activityId"), new BoolQuery.Builder()).build())));
    }
}

